<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package razan-payamava
 */

?>



<div class="rankmath-header mainView">
	<?php
	if (function_exists('rank_math_the_breadcrumbs')) {
		rank_math_the_breadcrumbs();
	} ?>
</div>



<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="mainSinglepage mainView">

		<div class="singleContentSide">
			<header class="entry-header">

				<?php
				the_title('<h1 class="entry-title-single22">', '</h1>');
				?>

			</header>

			<div class="additionalSingle">

				<div class="dateSide">

					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path
							d="M7.25 5V2C7.25 1.59 7.59 1.25 8 1.25C8.41 1.25 8.75 1.59 8.75 2V5C8.75 5.41 8.41 5.75 8 5.75C7.59 5.75 7.25 5.41 7.25 5Z"
							fill="#008F83" />
						<path
							d="M15.25 5V2C15.25 1.59 15.59 1.25 16 1.25C16.41 1.25 16.75 1.59 16.75 2V5C16.75 5.41 16.41 5.75 16 5.75C15.59 5.75 15.25 5.41 15.25 5Z"
							fill="#008F83" />
						<path
							d="M8.12 14.4223C7.99 14.3723 7.89 14.3023 7.79 14.2123C7.61 14.0223 7.5 13.7723 7.5 13.5023C7.5 13.3723 7.53 13.2423 7.58 13.1223C7.63 13.0023 7.7 12.8923 7.79 12.7923C7.89 12.7023 7.99 12.6323 8.12 12.5823C8.48 12.4323 8.93 12.5123 9.21 12.7923C9.39 12.9823 9.5 13.2423 9.5 13.5023C9.5 13.5623 9.49 13.6323 9.48 13.7023C9.47 13.7623 9.45 13.8223 9.42 13.8823C9.4 13.9423 9.37 14.0023 9.33 14.0623C9.3 14.1123 9.25 14.1623 9.21 14.2123C9.02 14.3923 8.76 14.5023 8.5 14.5023C8.37 14.5023 8.24 14.4723 8.12 14.4223Z"
							fill="#008F83" />
						<path
							d="M11.62 14.4189C11.49 14.3689 11.39 14.2989 11.29 14.2089C11.11 14.0189 11 13.7689 11 13.4989C11 13.3689 11.03 13.2389 11.08 13.1189C11.13 12.9989 11.2 12.8889 11.29 12.7889C11.39 12.6989 11.49 12.6289 11.62 12.5789C11.98 12.4189 12.43 12.5089 12.71 12.7889C12.89 12.9789 13 13.2389 13 13.4989C13 13.5589 12.99 13.6289 12.98 13.6989C12.97 13.7589 12.95 13.8189 12.92 13.8789C12.9 13.9389 12.87 13.9989 12.83 14.0589C12.8 14.1089 12.75 14.1589 12.71 14.2089C12.52 14.3889 12.26 14.4989 12 14.4989C11.87 14.4989 11.74 14.4689 11.62 14.4189Z"
							fill="#008F83" />
						<path
							d="M15.12 14.4189C14.99 14.3689 14.89 14.2989 14.79 14.2089C14.75 14.1589 14.71 14.1089 14.67 14.0589C14.63 13.9989 14.6 13.9389 14.58 13.8789C14.55 13.8189 14.53 13.7589 14.52 13.6989C14.51 13.6289 14.5 13.5589 14.5 13.4989C14.5 13.2389 14.61 12.9789 14.79 12.7889C14.89 12.6989 14.99 12.6289 15.12 12.5789C15.49 12.4189 15.93 12.5089 16.21 12.7889C16.39 12.9789 16.5 13.2389 16.5 13.4989C16.5 13.5589 16.49 13.6289 16.48 13.6989C16.47 13.7589 16.45 13.8189 16.42 13.8789C16.4 13.9389 16.37 13.9989 16.33 14.0589C16.3 14.1089 16.25 14.1589 16.21 14.2089C16.02 14.3889 15.76 14.4989 15.5 14.4989C15.37 14.4989 15.24 14.4689 15.12 14.4189Z"
							fill="#008F83" />
						<path
							d="M8.12 17.9231C8 17.8731 7.89 17.8031 7.79 17.7131C7.61 17.5231 7.5 17.2631 7.5 17.0031C7.5 16.8731 7.53 16.7431 7.58 16.6231C7.63 16.4931 7.7 16.3831 7.79 16.2931C8.16 15.9231 8.84 15.9231 9.21 16.2931C9.39 16.4831 9.5 16.7431 9.5 17.0031C9.5 17.2631 9.39 17.5231 9.21 17.7131C9.02 17.8931 8.76 18.0031 8.5 18.0031C8.37 18.0031 8.24 17.9731 8.12 17.9231Z"
							fill="#008F83" />
						<path
							d="M11.29 17.7131C11.11 17.5231 11 17.2631 11 17.0031C11 16.8731 11.03 16.7431 11.08 16.6231C11.13 16.4931 11.2 16.3831 11.29 16.2931C11.66 15.9231 12.34 15.9231 12.71 16.2931C12.8 16.3831 12.87 16.4931 12.92 16.6231C12.97 16.7431 13 16.8731 13 17.0031C13 17.2631 12.89 17.5231 12.71 17.7131C12.52 17.8931 12.26 18.0031 12 18.0031C11.74 18.0031 11.48 17.8931 11.29 17.7131Z"
							fill="#008F83" />
						<path
							d="M14.79 17.7109C14.7 17.6209 14.63 17.5109 14.58 17.3809C14.53 17.2609 14.5 17.1309 14.5 17.0009C14.5 16.8709 14.53 16.7409 14.58 16.6209C14.63 16.4909 14.7 16.3809 14.79 16.2909C15.02 16.0609 15.37 15.9509 15.69 16.0209C15.76 16.0309 15.82 16.0509 15.88 16.0809C15.94 16.1009 16 16.1309 16.06 16.1709C16.11 16.2009 16.16 16.2509 16.21 16.2909C16.39 16.4809 16.5 16.7409 16.5 17.0009C16.5 17.2609 16.39 17.5209 16.21 17.7109C16.02 17.8909 15.76 18.0009 15.5 18.0009C15.24 18.0009 14.98 17.8909 14.79 17.7109Z"
							fill="#008F83" />
						<path
							d="M3.5 9.84375C3.09 9.84375 2.75 9.50375 2.75 9.09375C2.75 8.68375 3.09 8.34375 3.5 8.34375H20.5C20.91 8.34375 21.25 8.68375 21.25 9.09375C21.25 9.50375 20.91 9.84375 20.5 9.84375H3.5Z"
							fill="#008F83" />
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M8 22.75C4.35 22.75 2.25 20.65 2.25 17V8.5C2.25 4.85 4.35 2.75 8 2.75H16C19.65 2.75 21.75 4.85 21.75 8.5V17C21.75 20.65 19.65 22.75 16 22.75H8ZM3.75 8.5V17C3.75 19.86 5.14 21.25 8 21.25H16C18.86 21.25 20.25 19.86 20.25 17V8.5C20.25 5.64 18.86 4.25 16 4.25H8C5.14 4.25 3.75 5.64 3.75 8.5Z"
							fill="#008F83" />
					</svg>

					<?php echo get_the_date(); ?>
				</div>

				<div class="catSide">

					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M10.2704 11.5929L4.37039 8.97293C2.87039 8.30293 2.65039 7.40293 2.65039 6.91293C2.65039 6.42293 2.87039 5.52293 4.37039 4.85293L10.2704 2.23293C11.1404 1.84293 12.4504 1.84293 13.3204 2.23293L19.2304 4.85293C20.7204 5.51293 20.9504 6.42293 20.9504 6.91293C20.9504 7.40293 20.7304 8.30293 19.2304 8.97293L13.3204 11.5929C12.8804 11.7929 12.3404 11.8829 11.7904 11.8829C11.2504 11.8829 10.7004 11.7829 10.2704 11.5929ZM10.8804 3.60293L4.98039 6.22293C4.37039 6.50293 4.15039 6.78293 4.15039 6.91293C4.15039 7.04293 4.37039 7.33293 4.97039 7.60293L10.8704 10.2229C11.3504 10.4329 12.2204 10.4329 12.7004 10.2229L18.6104 7.60293C19.2204 7.33293 19.4404 7.04293 19.4404 6.91293C19.4404 6.78293 19.2204 6.49293 18.6104 6.22293L12.7104 3.60293C12.4704 3.50293 12.1304 3.44293 11.7904 3.44293C11.4504 3.44293 11.1204 3.49293 10.8804 3.60293Z"
							fill="#008F83" />
						<path
							d="M10.88 16.8469L4.09 13.8269C3.06 13.3769 2.25 12.1269 2.25 10.9969C2.25 10.5869 2.59 10.2469 3 10.2469C3.41 10.2469 3.75 10.5869 3.75 10.9969C3.75 11.5469 4.2 12.2369 4.7 12.4669L11.49 15.4869C11.81 15.6269 12.18 15.6269 12.51 15.4869L19.3 12.4669C19.8 12.2469 20.25 11.5469 20.25 10.9969C20.25 10.5869 20.59 10.2469 21 10.2469C21.41 10.2469 21.75 10.5869 21.75 10.9969C21.75 12.1269 20.94 13.3769 19.91 13.8369L13.12 16.8569C12.76 17.0069 12.38 17.0869 12 17.0869C11.62 17.0869 11.24 17.0069 10.88 16.8469Z"
							fill="#008F83" />
						<path
							d="M10.88 21.8541L4.09 18.8341C2.97 18.3341 2.25 17.2241 2.25 15.9941C2.25 15.5841 2.59 15.2441 3 15.2441C3.41 15.2441 3.75 15.5941 3.75 16.0041C3.75 16.6341 4.12 17.2141 4.7 17.4741L11.49 20.4941C11.81 20.6341 12.18 20.6341 12.51 20.4941L19.3 17.4741C19.88 17.2141 20.25 16.6441 20.25 16.0041C20.25 15.5941 20.59 15.2541 21 15.2541C21.41 15.2541 21.75 15.5941 21.75 16.0041C21.75 17.2341 21.03 18.3441 19.91 18.8441L13.12 21.8641C12.76 22.0141 12.38 22.0941 12 22.0941C11.62 22.0941 11.24 22.0141 10.88 21.8541Z"
							fill="#008F83" />
					</svg>


					<?php
					$post_id = get_the_ID();

					$primary_category_id = get_post_meta($post_id, 'rank_math_primary_category', true);

					if ($primary_category_id) {
						$primary_category = get_term($primary_category_id, 'category');
						if (!is_wp_error($primary_category)) {
							echo esc_html($primary_category->name);
						}
					} else {
						$categories = get_the_category($post_id);
						if (!empty($categories)) {
							echo esc_html($categories[0]->name);
						}
					}
					?>


				</div>

				<div class="shareButtons">
					<?php add_share_buttons() ?>
				</div>

			</div>

			<div class="single-thumbnail">
				<?php razan_payamava_post_thumbnail(); ?>
			</div>

			<div class="res-shareButtons">
				<div class="shareButtons">
					<?php add_share_buttons() ?>
				</div>
			</div>

			<div class="listSideUnderThumb">

				<?php
				$toc_headings = get_field('toc_headings');
				if ($toc_headings) { ?>

					<div class="post-headings extra-post-headings">

						<div class="extra-tab-title">
							<span class="">فهرست مطالب</span>
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M6 12H18" stroke="black" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M12 18V6" stroke="black" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
							</svg>
						</div>

						<ul class="listTableContent"><?php

						foreach ($toc_headings as $heading) {
							echo '<li><a href="#' . $heading['value'] . '">' . $heading['label'] . '</a></li>';
							$heading;
						}
						?>
						</ul>
					</div>
					
				<?php } ?>

				<div class="quikAccess extra-quikAccess extra-quikAccess-post">
					<div class="extra-tab-title">
						<span>دسترسی‌های سریع</span>
						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M6 12H18" stroke="black" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
							<path d="M12 18V6" stroke="black" stroke-width="1.5" stroke-linecap="round"
								stroke-linejoin="round" />
						</svg>
					</div>

					<ul>
						<li class="listSideItem">
							<a href="#recentPosts">مقالات مشابه</a>
						</li>

						<li class="listSideItem">
							<a href="#projectsRelated">پرو‌ژه‌های مرتبط</a>
						</li>
					</ul>

				</div>

			</div>


			<div class="entry-content-single entry-content">
				<?php
				the_content();
				?>
			</div>
		</div>


		<div class="sidebarSinglePage">

			<div class="listSide">

				<?php
				$toc_headings = get_field('toc_headings');
				if ($toc_headings) { ?>


					<div class="post-headings">
						<div class="tabelBarContent"><span>فهرست مطالب</span></div>

						<ul class="listTableContent"><?php

						foreach ($toc_headings as $heading) {
							echo '<li><a href="#' . $heading['value'] . '">' . $heading['label'] . '</a></li>';
							$heading;
						}
						?>
						</ul>
					</div>

				<?php } ?>

				<div class="listSideItem">
					<a href="#recentPosts">مقالات مشابه</a>
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M5.25 6C5.25 5.58579 5.58579 5.25 6 5.25H15C15.4142 5.25 15.75 5.58579 15.75 6C15.75 6.41421 15.4142 6.75 15 6.75H7.81066L18.5303 17.4697C18.8232 17.7626 18.8232 18.2374 18.5303 18.5303C18.2374 18.8232 17.7626 18.8232 17.4697 18.5303L6.75 7.81066V15C6.75 15.4142 6.41421 15.75 6 15.75C5.58579 15.75 5.25 15.4142 5.25 15V6Z"
							fill="#020014" />
					</svg>

				</div>

				<div class="listSideItem">
					<a href="#projectsRelated">پرو‌ژه‌های مرتبط</a>
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M5.25 6C5.25 5.58579 5.58579 5.25 6 5.25H15C15.4142 5.25 15.75 5.58579 15.75 6C15.75 6.41421 15.4142 6.75 15 6.75H7.81066L18.5303 17.4697C18.8232 17.7626 18.8232 18.2374 18.5303 18.5303C18.2374 18.8232 17.7626 18.8232 17.4697 18.5303L6.75 7.81066V15C6.75 15.4142 6.41421 15.75 6 15.75C5.58579 15.75 5.25 15.4142 5.25 15V6Z"
							fill="#020014" />
					</svg>

				</div>

			</div>

		</div>

	</div>

</article>