<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package razan-payamava
 */


$product_catalog = get_field('product_catalog');
$product_video = get_field('product_video');
$product_poster = get_field('product_poster');
//


$product_pecifics = get_field('product_pecifics');
$main_explaintion = get_field('main_explaintion');
$how_to_use = get_field('how_to_use');
$source_drug = get_field('source_drug');
$seciurity_points = get_field('seciurity_points');
$fight_drug = get_field('fight_drug');
$info_profession = get_field('info_profession');


?>



<div class="rankmath-header">
	<?php
	if (function_exists('rank_math_the_breadcrumbs')) {
		rank_math_the_breadcrumbs();
	} ?>
</div>



<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="upSideHeaderPro">

		<?php
		$post_id = get_the_ID();

		$primary_term_id = get_post_meta($post_id, 'rank_math_primary_product_cat', true);

		if ($primary_term_id) {
			$primary_term = get_term($primary_term_id, 'product_cat');
			if (!is_wp_error($primary_term)) { ?>
				<div class="catSide">
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M10.2704 11.5929L4.37039 8.97293C2.87039 8.30293 2.65039 7.40293 2.65039 6.91293C2.65039 6.42293 2.87039 5.52293 4.37039 4.85293L10.2704 2.23293C11.1404 1.84293 12.4504 1.84293 13.3204 2.23293L19.2304 4.85293C20.7204 5.51293 20.9504 6.42293 20.9504 6.91293C20.9504 7.40293 20.7304 8.30293 19.2304 8.97293L13.3204 11.5929C12.8804 11.7929 12.3404 11.8829 11.7904 11.8829C11.2504 11.8829 10.7004 11.7829 10.2704 11.5929ZM10.8804 3.60293L4.98039 6.22293C4.37039 6.50293 4.15039 6.78293 4.15039 6.91293C4.15039 7.04293 4.37039 7.33293 4.97039 7.60293L10.8704 10.2229C11.3504 10.4329 12.2204 10.4329 12.7004 10.2229L18.6104 7.60293C19.2204 7.33293 19.4404 7.04293 19.4404 6.91293C19.4404 6.78293 19.2204 6.49293 18.6104 6.22293L12.7104 3.60293C12.4704 3.50293 12.1304 3.44293 11.7904 3.44293C11.4504 3.44293 11.1204 3.49293 10.8804 3.60293Z"
							fill="#008F83" />
						<path
							d="M10.88 16.8469L4.09 13.8269C3.06 13.3769 2.25 12.1269 2.25 10.9969C2.25 10.5869 2.59 10.2469 3 10.2469C3.41 10.2469 3.75 10.5869 3.75 10.9969C3.75 11.5469 4.2 12.2369 4.7 12.4669L11.49 15.4869C11.81 15.6269 12.18 15.6269 12.51 15.4869L19.3 12.4669C19.8 12.2469 20.25 11.5469 20.25 10.9969C20.25 10.5869 20.59 10.2469 21 10.2469C21.41 10.2469 21.75 10.5869 21.75 10.9969C21.75 12.1269 20.94 13.3769 19.91 13.8369L13.12 16.8569C12.76 17.0069 12.38 17.0869 12 17.0869C11.62 17.0869 11.24 17.0069 10.88 16.8469Z"
							fill="#008F83" />
						<path
							d="M10.88 21.8541L4.09 18.8341C2.97 18.3341 2.25 17.2241 2.25 15.9941C2.25 15.5841 2.59 15.2441 3 15.2441C3.41 15.2441 3.75 15.5941 3.75 16.0041C3.75 16.6341 4.12 17.2141 4.7 17.4741L11.49 20.4941C11.81 20.6341 12.18 20.6341 12.51 20.4941L19.3 17.4741C19.88 17.2141 20.25 16.6441 20.25 16.0041C20.25 15.5941 20.59 15.2541 21 15.2541C21.41 15.2541 21.75 15.5941 21.75 16.0041C21.75 17.2341 21.03 18.3441 19.91 18.8441L13.12 21.8641C12.76 22.0141 12.38 22.0941 12 22.0941C11.62 22.0941 11.24 22.0141 10.88 21.8541Z"
							fill="#008F83" />
					</svg>
					<?php echo esc_html($primary_term->name); ?>
				</div>
			<?php }
		} else {
			$terms = get_the_terms($post_id, 'product_cat');
			if (!empty($terms) && !is_wp_error($terms)) {
				$term = $terms[0]; ?>
				<div class="catSide">
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" clip-rule="evenodd"
							d="M10.2704 11.5929L4.37039 8.97293C2.87039 8.30293 2.65039 7.40293 2.65039 6.91293C2.65039 6.42293 2.87039 5.52293 4.37039 4.85293L10.2704 2.23293C11.1404 1.84293 12.4504 1.84293 13.3204 2.23293L19.2304 4.85293C20.7204 5.51293 20.9504 6.42293 20.9504 6.91293C20.9504 7.40293 20.7304 8.30293 19.2304 8.97293L13.3204 11.5929C12.8804 11.7929 12.3404 11.8829 11.7904 11.8829C11.2504 11.8829 10.7004 11.7829 10.2704 11.5929ZM10.8804 3.60293L4.98039 6.22293C4.37039 6.50293 4.15039 6.78293 4.15039 6.91293C4.15039 7.04293 4.37039 7.33293 4.97039 7.60293L10.8704 10.2229C11.3504 10.4329 12.2204 10.4329 12.7004 10.2229L18.6104 7.60293C19.2204 7.33293 19.4404 7.04293 19.4404 6.91293C19.4404 6.78293 19.2204 6.49293 18.6104 6.22293L12.7104 3.60293C12.4704 3.50293 12.1304 3.44293 11.7904 3.44293C11.4504 3.44293 11.1204 3.49293 10.8804 3.60293Z"
							fill="#008F83" />
						<path
							d="M10.88 16.8469L4.09 13.8269C3.06 13.3769 2.25 12.1269 2.25 10.9969C2.25 10.5869 2.59 10.2469 3 10.2469C3.41 10.2469 3.75 10.5869 3.75 10.9969C3.75 11.5469 4.2 12.2369 4.7 12.4669L11.49 15.4869C11.81 15.6269 12.18 15.6269 12.51 15.4869L19.3 12.4669C19.8 12.2469 20.25 11.5469 20.25 10.9969C20.25 10.5869 20.59 10.2469 21 10.2469C21.41 10.2469 21.75 10.5869 21.75 10.9969C21.75 12.1269 20.94 13.3769 19.91 13.8369L13.12 16.8569C12.76 17.0069 12.38 17.0869 12 17.0869C11.62 17.0869 11.24 17.0069 10.88 16.8469Z"
							fill="#008F83" />
						<path
							d="M10.88 21.8541L4.09 18.8341C2.97 18.3341 2.25 17.2241 2.25 15.9941C2.25 15.5841 2.59 15.2441 3 15.2441C3.41 15.2441 3.75 15.5941 3.75 16.0041C3.75 16.6341 4.12 17.2141 4.7 17.4741L11.49 20.4941C11.81 20.6341 12.18 20.6341 12.51 20.4941L19.3 17.4741C19.88 17.2141 20.25 16.6441 20.25 16.0041C20.25 15.5941 20.59 15.2541 21 15.2541C21.41 15.2541 21.75 15.5941 21.75 16.0041C21.75 17.2341 21.03 18.3441 19.91 18.8441L13.12 21.8641C12.76 22.0141 12.38 22.0941 12 22.0941C11.62 22.0941 11.24 22.0141 10.88 21.8541Z"
							fill="#008F83" />
					</svg>

					<?php echo esc_html($term->name); ?>
				</div>
			<?php }
		}
		?>





		<?php
		the_title('<h1 class="entry-title-single22">', '</h1>');
		?>

		<div class="shareButtons">
			<?php add_share_buttons() ?>
		</div>

	</div>



	<div class="thuSideHeaderPro">

		<?php razan_payamava_post_thumbnail(); ?>


		<div class="videoSide" id="videoSide">

			<div class="videoSideTitleAn" id="videoSideTitleAn">
				معرفی <wbr> <?php echo get_the_title(); ?>
			</div>

			<video id="myVideoHomeSin" poster="<?php echo $product_poster ?>">
				<source src="<?php echo $product_video ?>">
				مرورگر شما از ویدیو پشتیبانی نمی‌کند.
			</video>

			<div class="playBtnHome" id="playBtnHomeSin">
				<svg width="160" height="160" viewBox="0 0 160 160" fill="none" xmlns="http://www.w3.org/2000/svg">
					<foreignObject x="-101.587" y="-101.587" width="363.175" height="363.175">
						<div xmlns="http://www.w3.org/1999/xhtml"
							style="backdrop-filter:blur(50.79px);clip-path:url(#bgblur_0_2273_1734_clip_path);height:100%;width:100%">
						</div>
					</foreignObject>
					<g data-figma-bg-blur-radius="101.587">
						<rect width="160" height="160" rx="80" fill="white" fill-opacity="0.08" />
						<rect x="0.777605" y="0.777605" width="158.445" height="158.445" rx="79.2224"
							stroke="url(#paint0_linear_2273_1734)" stroke-opacity="0.4" stroke-width="1.55521" />
						<path
							d="M92.3474 22.1698C91.7409 21.9726 91.2457 21.675 90.8617 21.2769C90.4801 20.8714 90.23 20.3927 90.1112 19.8408C90.0023 19.2838 90.0525 18.6833 90.2616 18.0393L91.8446 13.1644L93.4507 13.6866L91.8348 18.6626C91.74 18.9546 91.7123 19.2437 91.7519 19.5297C91.7939 19.8083 91.9029 20.059 92.0789 20.2818C92.2573 20.4971 92.5 20.6547 92.807 20.7545C93.114 20.8543 93.4029 20.8695 93.6737 20.8003C93.947 20.7236 94.1824 20.5848 94.38 20.3842C94.5801 20.176 94.7275 19.9259 94.8223 19.6338L96.4382 14.6579L98.0442 15.18L96.4284 20.156C96.3336 20.448 96.3059 20.7371 96.3455 21.0232C96.3875 21.3017 96.4964 21.5524 96.6724 21.7752C96.8509 21.9905 97.0936 22.1481 97.4006 22.2479C97.7075 22.3477 97.9964 22.363 98.2673 22.2937C98.5405 22.217 98.776 22.0783 98.9736 21.8776C99.1736 21.6694 99.3211 21.4193 99.4159 21.1273L101.032 16.1513L102.638 16.6734L101.055 21.5483C100.846 22.1923 100.53 22.7064 100.107 23.0905C99.6942 23.4696 99.2143 23.711 98.6674 23.8147C98.1229 23.9108 97.5475 23.8603 96.941 23.6632C96.6265 23.5609 96.3404 23.4224 96.0826 23.2475C95.8224 23.0801 95.6018 22.8801 95.4207 22.6474C95.2397 22.4146 95.0908 22.1593 94.9741 21.8812C94.7239 22.04 94.4535 22.159 94.1628 22.2384C93.8821 22.3127 93.5861 22.3448 93.2748 22.3347C92.971 22.327 92.6619 22.272 92.3474 22.1698Z"
							fill="white" />
						<path
							d="M104.088 26.3994C103.588 26.1678 103.211 25.8373 102.959 25.408C102.706 24.9787 102.576 24.5017 102.567 23.977C102.568 23.4485 102.69 22.9234 102.931 22.4017C103.179 21.8658 103.518 21.4329 103.949 21.1029C104.386 20.7762 104.88 20.5887 105.432 20.5405C105.987 20.4851 106.568 20.598 107.175 20.8793C107.789 21.1639 108.248 21.5324 108.55 21.9849C108.853 22.4374 109.014 22.9328 109.034 23.4713C109.054 24.0097 108.941 24.5434 108.697 25.0721L107.437 27.7946L105.969 27.1146L106.39 26.2035L106.369 26.1936C106.173 26.3369 105.956 26.4491 105.719 26.5302C105.489 26.6146 105.238 26.6503 104.967 26.6373C104.695 26.6243 104.402 26.545 104.088 26.3994ZM105.086 25.3389C105.372 25.4713 105.651 25.514 105.924 25.4671C106.198 25.4201 106.444 25.3 106.664 25.1067C106.894 24.9095 107.078 24.6609 107.217 24.3608C107.356 24.0607 107.423 23.7662 107.417 23.4775C107.423 23.1849 107.355 22.9192 107.214 22.6803C107.073 22.4414 106.859 22.2558 106.573 22.1234C106.281 21.9878 105.994 21.9417 105.713 21.9854C105.44 22.0323 105.19 22.1508 104.963 22.3408C104.747 22.527 104.57 22.7701 104.431 23.0702C104.292 23.3704 104.218 23.6703 104.21 23.97C104.212 24.2659 104.283 24.5333 104.424 24.7722C104.572 25.0143 104.793 25.2033 105.086 25.3389Z"
							fill="white" />
						<path
							d="M111.223 30.0849C110.768 29.8037 110.49 29.4517 110.39 29.029C110.296 28.6105 110.388 28.1768 110.665 27.7278L113.721 22.7723L115.098 23.6224L112.066 28.5376C112.013 28.6247 111.995 28.7204 112.014 28.8246C112.044 28.9263 112.103 29.004 112.19 29.0578L113.305 29.7465L112.58 30.9226L111.223 30.0849ZM111.328 24.6952L112.054 23.5191L115.742 25.7962L115.016 26.9723L111.328 24.6952Z"
							fill="white" />
						<path
							d="M116.526 33.8589C116.04 33.4714 115.689 33.0209 115.473 32.5073C115.258 31.9937 115.18 31.473 115.237 30.9452C115.3 30.4113 115.508 29.9225 115.861 29.4789C116.213 29.0353 116.64 28.7262 117.142 28.5516C117.648 28.3708 118.175 28.3277 118.723 28.4224C119.272 28.517 119.789 28.758 120.276 29.1455L120.867 29.6164L120.007 30.6977L119.416 30.2268C119.157 30.0208 118.888 29.8972 118.609 29.8561C118.336 29.8198 118.069 29.8586 117.807 29.9724C117.557 30.0849 117.336 30.2613 117.145 30.5016C116.953 30.7419 116.829 30.9998 116.77 31.2755C116.723 31.5499 116.748 31.8161 116.844 32.0741C116.947 32.3371 117.128 32.5716 117.386 32.7776L117.978 33.2485L117.117 34.3298L116.526 33.8589Z"
							fill="white" />
						<path
							d="M119.707 36.4954L125.84 30.436L126.977 31.5876L124.826 33.7125C125.149 33.7479 125.443 33.8389 125.709 33.9853C125.975 34.1318 126.208 34.3059 126.407 34.5076C126.816 34.9223 127.067 35.3499 127.159 35.7904C127.256 36.2365 127.226 36.6707 127.067 37.0929C126.909 37.5152 126.653 37.9006 126.3 38.2492L123.839 40.6813L122.702 39.5297L125.164 37.0977C125.337 36.9261 125.453 36.7292 125.51 36.5068C125.572 36.2788 125.574 36.0505 125.514 35.8218C125.46 35.5987 125.347 35.4003 125.175 35.2266C125.009 35.0585 124.813 34.9431 124.585 34.8804C124.368 34.8178 124.146 34.8108 123.917 34.8595C123.7 34.9083 123.507 35.0157 123.339 35.1817L120.844 37.6469L119.707 36.4954Z"
							fill="white" />
						<path
							d="M130.062 49.4987C129.876 49.188 129.778 48.8653 129.77 48.5303C129.773 48.1981 129.895 47.8814 130.137 47.5802L135.176 41.6768L136.142 43.2873L131.457 48.4269C131.418 48.4688 131.396 48.5093 131.392 48.5485C131.392 48.5944 131.405 48.6376 131.429 48.6782C131.453 48.7187 131.483 48.7463 131.52 48.7612C131.56 48.7828 131.608 48.7862 131.664 48.7713L138.437 47.1159L139.361 48.6555L131.799 50.3292C131.431 50.4035 131.094 50.3623 130.789 50.2056C130.49 50.0449 130.248 49.8093 130.062 49.4987Z"
							fill="white" />
						<path
							d="M133.169 55.0147L138.666 52.5523L139.332 54.0399L133.835 56.5023L133.169 55.0147ZM139.656 53.0015C139.544 52.75 139.535 52.4906 139.632 52.2233C139.738 51.9599 139.917 51.7719 140.168 51.6592C140.42 51.5466 140.676 51.5399 140.936 51.639C141.206 51.7422 141.398 51.9195 141.51 52.1711C141.623 52.4226 141.626 52.68 141.519 52.9434C141.423 53.2107 141.25 53.4007 140.998 53.5134C140.747 53.626 140.486 53.6308 140.215 53.5276C139.955 53.4284 139.769 53.2531 139.656 53.0015Z"
							fill="white" />
						<path
							d="M135.765 62.0875C135.615 61.6063 135.556 61.1506 135.587 60.7204C135.628 60.2953 135.748 59.9117 135.947 59.5695C136.153 59.225 136.423 58.9266 136.757 58.6742C137.098 58.4196 137.494 58.2221 137.945 58.0817C138.517 57.9038 139.052 57.861 139.55 57.9532C140.059 58.0505 140.501 58.2674 140.878 58.6037C141.257 58.9475 141.533 59.3975 141.706 59.9539C141.781 60.1945 141.818 60.4343 141.818 60.6734C141.821 60.92 141.786 61.1534 141.714 61.3736C141.643 61.5938 141.538 61.7872 141.4 61.9538L141.404 61.9651L144.595 60.9719L145.075 62.5169L139.832 64.1489C139.2 64.3454 138.609 64.3934 138.058 64.2927C137.515 64.1896 137.046 63.9523 136.65 63.5808C136.254 63.2093 135.959 62.7115 135.765 62.0875ZM137.084 61.6768C137.18 61.9851 137.337 62.2248 137.555 62.3961C137.773 62.5673 138.028 62.6695 138.319 62.7027C138.612 62.7435 138.916 62.7147 139.232 62.6164C139.547 62.5182 139.814 62.3691 140.033 62.1693C140.253 61.9769 140.405 61.7483 140.487 61.4835C140.57 61.2187 140.563 60.9322 140.467 60.6239C140.374 60.3232 140.217 60.0834 139.996 59.9047C139.778 59.7335 139.523 59.6275 139.23 59.5867C138.939 59.5535 138.636 59.586 138.32 59.6843C138.004 59.7826 137.736 59.9279 137.516 60.1202C137.297 60.3201 137.147 60.5524 137.064 60.8172C136.984 61.0896 136.991 61.3761 137.084 61.6768Z"
							fill="white" />
						<path
							d="M137.722 69.38C137.598 68.7064 137.617 68.0944 137.78 67.544C137.952 66.9999 138.237 66.5471 138.635 66.1855C139.034 65.8317 139.512 65.6034 140.07 65.5007C140.697 65.385 141.266 65.4122 141.778 65.582C142.289 65.7519 142.714 66.034 143.05 66.4282C143.387 66.8225 143.607 67.2983 143.709 67.8558C143.832 68.5217 143.792 69.0856 143.589 69.5473C143.387 70.0169 143.068 70.3919 142.631 70.6726C142.202 70.9518 141.701 71.1442 141.128 71.2499C141.051 71.2641 140.957 71.2774 140.847 71.2896C140.745 71.3004 140.666 71.3031 140.609 71.2976L139.871 67.2906C139.642 67.3968 139.46 67.5384 139.325 67.7155C139.19 67.9004 139.102 68.1129 139.058 68.3532C139.023 68.5997 139.032 68.8662 139.085 69.1527L139.389 70.802L138.03 71.0525L137.722 69.38ZM140.937 67.082L141.393 69.5559C141.537 69.5133 141.667 69.4612 141.784 69.3997C141.909 69.3367 142.015 69.2611 142.103 69.1728C142.191 69.0846 142.261 68.9876 142.313 68.8818C142.366 68.776 142.4 68.6576 142.416 68.5266C142.432 68.3956 142.426 68.2565 142.399 68.1094C142.364 67.9158 142.297 67.748 142.198 67.606C142.102 67.4717 141.986 67.365 141.851 67.2857C141.717 67.2065 141.57 67.1495 141.411 67.1146C141.254 67.0876 141.096 67.0767 140.937 67.082Z"
							fill="white" />
						<path
							d="M138.405 76.2151C138.366 75.5944 138.469 75.0318 138.713 74.5273C138.965 74.0223 139.318 73.6135 139.772 73.3009C140.233 72.9879 140.759 72.8128 141.348 72.7757C141.938 72.7386 142.477 72.8467 142.966 73.0999C143.463 73.3526 143.865 73.7139 144.17 74.1837C144.484 74.6531 144.66 75.1982 144.699 75.8189C144.738 76.4397 144.631 77.0026 144.379 77.5076C144.135 78.012 143.782 78.4208 143.32 78.7339C142.867 79.0464 142.345 79.2213 141.756 79.2584C141.167 79.2954 140.623 79.1876 140.126 78.9349C139.637 78.6817 139.236 78.3205 138.922 77.8511C138.616 77.3812 138.444 76.8359 138.405 76.2151ZM139.784 76.1283C139.805 76.4584 139.901 76.7363 140.073 76.9621C140.246 77.1958 140.469 77.3671 140.744 77.476C141.02 77.5928 141.323 77.6408 141.653 77.62C141.983 77.5992 142.277 77.5137 142.536 77.3633C142.795 77.2207 142.996 77.0227 143.138 76.7692C143.28 76.5236 143.341 76.2358 143.32 75.9057C143.299 75.5757 143.203 75.2939 143.03 75.0602C142.858 74.8343 142.634 74.663 142.359 74.5463C142.084 74.4374 141.781 74.3933 141.451 74.4141C141.121 74.4348 140.827 74.5165 140.567 74.659C140.309 74.8094 140.108 75.0074 139.966 75.2531C139.824 75.5066 139.763 75.7983 139.784 76.1283Z"
							fill="white" />
						<path
							d="M137.812 91.2611C137.997 90.651 138.285 90.1502 138.676 89.7588C139.074 89.3697 139.548 89.1107 140.097 88.9816C140.652 88.8624 141.253 88.9014 141.901 89.0986L146.804 90.591L146.313 92.2068L141.308 90.6834C141.014 90.594 140.725 90.5717 140.439 90.6166C140.162 90.6637 139.913 90.7774 139.694 90.9575C139.482 91.1399 139.329 91.3856 139.235 91.6944C139.141 92.0033 139.132 92.2925 139.206 92.562C139.288 92.8338 139.431 93.0667 139.635 93.2606C139.847 93.4568 140.1 93.5996 140.394 93.689L145.399 95.2123L144.908 96.8281L139.903 95.3047C139.609 95.2153 139.319 95.1931 139.034 95.2379C138.757 95.2851 138.508 95.3987 138.289 95.5789C138.077 95.7613 137.924 96.0069 137.83 96.3158C137.736 96.6246 137.726 96.9138 137.801 97.1834C137.883 97.4552 138.026 97.688 138.23 97.8819C138.442 98.0781 138.695 98.2209 138.989 98.3103L143.994 99.8337L143.503 101.449L138.599 99.957C137.952 99.7599 137.432 99.4535 137.04 99.0379C136.653 98.6321 136.402 98.1567 136.288 97.6118C136.182 97.0691 136.221 96.4926 136.407 95.8825C136.503 95.5661 136.636 95.2774 136.806 95.0164C136.968 94.7531 137.164 94.5287 137.393 94.3433C137.622 94.158 137.875 94.0044 138.15 93.8825C137.987 93.6353 137.863 93.367 137.778 93.0778C137.698 92.7985 137.66 92.5031 137.665 92.1916C137.666 91.8877 137.715 91.5775 137.812 91.2611Z"
							fill="white" />
						<path
							d="M133.734 103.06C133.956 102.556 134.279 102.173 134.704 101.913C135.128 101.652 135.602 101.513 136.126 101.494C136.655 101.486 137.182 101.598 137.708 101.829C138.248 102.067 138.688 102.399 139.026 102.823C139.36 103.254 139.557 103.745 139.616 104.296C139.682 104.85 139.58 105.433 139.311 106.045C139.038 106.665 138.678 107.131 138.232 107.442C137.786 107.752 137.293 107.923 136.756 107.953C136.218 107.982 135.682 107.88 135.149 107.645L132.404 106.436L133.055 104.955L133.974 105.36L133.984 105.338C133.837 105.144 133.72 104.93 133.635 104.694C133.546 104.466 133.506 104.215 133.513 103.944C133.521 103.672 133.595 103.377 133.734 103.06ZM134.813 104.039C134.687 104.327 134.649 104.607 134.701 104.88C134.754 105.152 134.878 105.397 135.076 105.613C135.277 105.839 135.529 106.019 135.832 106.152C136.134 106.285 136.43 106.347 136.719 106.336C137.011 106.336 137.275 106.263 137.511 106.118C137.747 105.972 137.929 105.755 138.056 105.467C138.186 105.171 138.226 104.884 138.177 104.604C138.125 104.332 138.002 104.084 137.808 103.861C137.617 103.648 137.371 103.475 137.068 103.341C136.766 103.208 136.465 103.14 136.165 103.137C135.869 103.144 135.603 103.221 135.367 103.366C135.128 103.519 134.943 103.743 134.813 104.039Z"
							fill="white" />
						<path
							d="M130.187 110.272C130.46 109.811 130.806 109.526 131.227 109.418C131.643 109.317 132.079 109.401 132.533 109.669L137.543 112.634L136.72 114.027L131.75 111.086C131.662 111.034 131.566 111.019 131.462 111.04C131.361 111.071 131.284 111.131 131.232 111.219L130.565 112.348L129.376 111.644L130.187 110.272ZM135.576 110.276L136.765 110.98L134.56 114.711L133.371 114.008L135.576 110.276Z"
							fill="white" />
						<path
							d="M126.517 115.647C126.895 115.153 127.339 114.794 127.848 114.569C128.357 114.344 128.876 114.255 129.405 114.303C129.939 114.356 130.432 114.554 130.882 114.899C131.332 115.244 131.649 115.665 131.833 116.163C132.023 116.666 132.076 117.193 131.992 117.743C131.908 118.294 131.677 118.816 131.299 119.31L130.839 119.91L129.742 119.07L130.202 118.469C130.403 118.207 130.521 117.936 130.557 117.656C130.588 117.382 130.544 117.115 130.426 116.856C130.308 116.607 130.128 116.39 129.884 116.203C129.64 116.016 129.38 115.896 129.104 115.843C128.829 115.801 128.563 115.83 128.307 115.932C128.046 116.04 127.815 116.225 127.614 116.487L127.155 117.087L126.058 116.247L126.517 115.647Z"
							fill="white" />
						<path
							d="M123.945 118.879L130.116 124.9L128.987 126.058L126.823 123.947C126.793 124.27 126.708 124.567 126.567 124.836C126.425 125.105 126.256 125.341 126.058 125.544C125.651 125.961 125.229 126.22 124.79 126.32C124.346 126.426 123.912 126.403 123.487 126.253C123.062 126.102 122.672 125.854 122.317 125.507L119.84 123.091L120.969 121.932L123.446 124.349C123.621 124.519 123.82 124.631 124.043 124.684C124.272 124.742 124.5 124.739 124.728 124.675C124.95 124.616 125.146 124.5 125.316 124.325C125.481 124.156 125.593 123.957 125.651 123.728C125.709 123.51 125.712 123.287 125.659 123.059C125.606 122.843 125.495 122.652 125.326 122.487L122.816 120.038L123.945 118.879Z"
							fill="white" />
						<path
							d="M111.145 129.488C111.452 129.296 111.773 129.193 112.108 129.178C112.44 129.175 112.759 129.291 113.064 129.527L119.058 134.455L117.466 135.451L112.243 130.864C112.2 130.825 112.159 130.804 112.12 130.801C112.074 130.802 112.031 130.815 111.991 130.84C111.951 130.865 111.924 130.896 111.91 130.933C111.889 130.974 111.886 131.022 111.902 131.077L113.683 137.821L112.161 138.773L110.348 131.242C110.267 130.875 110.302 130.537 110.452 130.229C110.607 129.927 110.838 129.68 111.145 129.488Z"
							fill="white" />
						<path
							d="M105.693 132.699L108.257 138.15L106.782 138.844L104.219 133.394L105.693 132.699ZM107.826 139.149C108.075 139.031 108.335 139.018 108.604 139.109C108.869 139.21 109.06 139.386 109.177 139.635C109.295 139.885 109.306 140.14 109.212 140.402C109.114 140.675 108.94 140.87 108.691 140.987C108.441 141.104 108.184 141.112 107.919 141.011C107.65 140.92 107.457 140.75 107.339 140.5C107.222 140.251 107.213 139.99 107.311 139.718C107.405 139.456 107.577 139.266 107.826 139.149Z"
							fill="white" />
						<path
							d="M98.6707 135.432C99.1489 135.273 99.6034 135.206 100.034 135.228C100.46 135.261 100.845 135.374 101.191 135.566C101.539 135.766 101.843 136.03 102.101 136.359C102.362 136.695 102.567 137.088 102.716 137.536C102.904 138.104 102.957 138.638 102.874 139.139C102.786 139.649 102.578 140.096 102.248 140.479C101.912 140.864 101.467 141.149 100.914 141.332C100.675 141.412 100.436 141.454 100.197 141.459C99.9504 141.466 99.7164 141.436 99.4949 141.368C99.2735 141.301 99.0782 141.2 98.9091 141.065L98.8979 141.069L99.9501 144.241L98.4146 144.751L96.6857 139.538C96.4774 138.911 96.4185 138.32 96.509 137.768C96.6019 137.223 96.8303 136.749 97.1944 136.346C97.5584 135.943 98.0505 135.638 98.6707 135.432ZM99.1057 136.744C98.7994 136.845 98.5627 137.007 98.3955 137.228C98.2284 137.45 98.131 137.706 98.1032 137.997C98.0679 138.291 98.1023 138.595 98.2064 138.909C98.3105 139.223 98.4645 139.487 98.6683 139.701C98.8647 139.918 99.096 140.065 99.3623 140.143C99.6285 140.22 99.9148 140.208 100.221 140.107C100.52 140.007 100.757 139.846 100.931 139.622C101.099 139.4 101.2 139.143 101.235 138.849C101.263 138.558 101.225 138.255 101.121 137.941C101.016 137.627 100.866 137.362 100.67 137.145C100.466 136.931 100.231 136.785 99.9647 136.707C99.6909 136.632 99.4046 136.644 99.1057 136.744Z"
							fill="white" />
						<path
							d="M91.4208 137.524C92.092 137.387 92.7042 137.395 93.2575 137.547C93.8047 137.709 94.2627 137.985 94.6316 138.376C94.9927 138.768 95.2299 139.242 95.343 139.798C95.4703 140.423 95.4538 140.993 95.2935 141.507C95.1333 142.022 94.8592 142.452 94.4713 142.796C94.0834 143.14 93.6118 143.369 93.0564 143.482C92.3929 143.618 91.8285 143.588 91.363 143.394C90.8899 143.201 90.5089 142.889 90.2202 142.458C89.933 142.034 89.7313 141.537 89.615 140.966C89.5993 140.889 89.5843 140.795 89.57 140.686C89.5573 140.584 89.5532 140.504 89.5576 140.447L93.5498 139.633C93.4394 139.407 93.2944 139.227 93.1148 139.095C92.9275 138.965 92.7134 138.88 92.4724 138.84C92.2252 138.81 91.9589 138.825 91.6735 138.883L90.0303 139.218L89.7545 137.864L91.4208 137.524ZM93.7783 140.695L91.3135 141.198C91.3588 141.341 91.4133 141.471 91.477 141.587C91.5423 141.71 91.6199 141.815 91.7097 141.901C91.7996 141.987 91.8979 142.055 92.0046 142.106C92.1113 142.156 92.2303 142.188 92.3616 142.202C92.4929 142.215 92.6318 142.207 92.7784 142.177C92.9713 142.138 93.1378 142.067 93.2779 141.967C93.4103 141.867 93.5149 141.75 93.5916 141.613C93.6683 141.477 93.7226 141.329 93.7545 141.17C93.7786 141.013 93.7866 140.854 93.7783 140.695Z"
							fill="white" />
						<path
							d="M84.6027 138.338C85.2226 138.287 85.7871 138.379 86.2961 138.614C86.8057 138.856 87.221 139.201 87.542 139.649C87.8637 140.105 88.0486 140.627 88.0967 141.215C88.1449 141.804 88.047 142.345 87.803 142.839C87.5597 143.341 87.206 143.749 86.742 144.063C86.2786 144.386 85.7369 144.572 85.117 144.623C84.4971 144.674 83.9323 144.578 83.4227 144.335C82.9137 144.1 82.4984 143.755 82.1767 143.3C81.8557 142.852 81.6711 142.334 81.623 141.745C81.5748 141.157 81.6724 140.612 81.9158 140.11C82.1597 139.616 82.5134 139.208 82.9768 138.885C83.4408 138.571 83.9828 138.388 84.6027 138.338ZM84.7154 139.715C84.3858 139.742 84.1098 139.843 83.8872 140.02C83.6568 140.196 83.4897 140.423 83.386 140.7C83.2744 140.978 83.2321 141.282 83.2591 141.611C83.2861 141.941 83.3771 142.234 83.5324 142.49C83.6798 142.746 83.8815 142.943 84.1376 143.08C84.3858 143.218 84.6748 143.273 85.0043 143.246C85.3339 143.219 85.6139 143.117 85.8443 142.94C86.0669 142.764 86.2339 142.537 86.3455 142.259C86.4492 141.982 86.4876 141.679 86.4606 141.349C86.4337 141.02 86.3465 140.727 86.1991 140.47C86.0439 140.214 85.8422 140.017 85.5939 139.88C85.3378 139.743 85.045 139.688 84.7154 139.715Z"
							fill="white" />
						<path
							d="M69.5323 138.098C70.1457 138.272 70.6518 138.551 71.0506 138.934C71.4471 139.325 71.7151 139.794 71.8546 140.341C71.9844 140.893 71.9569 141.495 71.7722 142.146L70.3739 147.078L68.7493 146.616L70.1766 141.583C70.2603 141.288 70.2771 140.998 70.2268 140.713C70.1743 140.437 70.056 140.19 69.8717 139.974C69.6853 139.766 69.4368 139.617 69.1263 139.529C68.8158 139.441 68.5265 139.437 68.2584 139.516C67.9883 139.603 67.7582 139.751 67.5683 139.959C67.3762 140.174 67.2383 140.43 67.1546 140.725L65.7272 145.758L64.1026 145.297L65.5299 140.264C65.6137 139.969 65.6304 139.679 65.5801 139.394C65.5277 139.117 65.4093 138.871 65.2251 138.655C65.0387 138.447 64.7902 138.298 64.4797 138.21C64.1691 138.122 63.8798 138.118 63.6118 138.197C63.3416 138.284 63.1116 138.432 62.9217 138.64C62.7296 138.855 62.5917 139.111 62.5079 139.406L61.0806 144.439L59.456 143.978L60.8543 139.047C61.039 138.396 61.3354 137.87 61.7434 137.47C62.1416 137.076 62.6121 136.817 63.1547 136.692C63.6951 136.576 64.2721 136.604 64.8856 136.779C65.2037 136.869 65.4949 136.997 65.7591 137.162C66.0254 137.319 66.2534 137.511 66.4431 137.736C66.6328 137.962 66.7911 138.212 66.9182 138.485C67.1623 138.317 67.428 138.188 67.7155 138.098C67.9933 138.013 68.2879 137.97 68.5993 137.968C68.9032 137.964 69.2141 138.007 69.5323 138.098Z"
							fill="white" />
						<path
							d="M57.6858 134.169C58.1943 134.382 58.5828 134.698 58.8513 135.118C59.1197 135.537 59.2683 136.009 59.2969 136.533C59.3152 137.061 59.2135 137.59 58.992 138.121C58.7645 138.665 58.4419 139.111 58.0243 139.457C57.5995 139.8 57.1125 140.006 56.5632 140.075C56.0109 140.151 55.426 140.06 54.8085 139.802C54.1839 139.541 53.7118 139.19 53.3925 138.749C53.0732 138.308 52.8935 137.819 52.8534 137.282C52.8133 136.745 52.9056 136.207 53.1301 135.67L54.2862 132.902L55.7789 133.526L55.392 134.452L55.4138 134.461C55.6047 134.311 55.8171 134.19 56.0509 134.1C56.2775 134.007 56.5267 133.962 56.7986 133.965C57.0705 133.968 57.3662 134.036 57.6858 134.169ZM56.7284 135.267C56.4378 135.145 56.1569 135.113 55.8855 135.17C55.6142 135.228 55.3724 135.357 55.1603 135.558C54.9379 135.764 54.763 136.02 54.6355 136.325C54.5081 136.63 54.4524 136.927 54.4685 137.215C54.4743 137.507 54.5521 137.77 54.7021 138.004C54.8521 138.237 55.0723 138.415 55.3629 138.536C55.6607 138.661 55.9489 138.696 56.2275 138.642C56.4989 138.584 56.7442 138.457 56.9636 138.258C57.1727 138.064 57.341 137.814 57.4684 137.509C57.5959 137.204 57.6582 136.902 57.6555 136.602C57.6424 136.306 57.5609 136.042 57.4109 135.808C57.2537 135.572 57.0262 135.391 56.7284 135.267Z"
							fill="white" />
						<path
							d="M50.4156 130.755C50.8814 131.019 51.1722 131.36 51.2882 131.779C51.3972 132.194 51.3219 132.631 51.0621 133.09L48.1945 138.157L46.7867 137.359L49.6311 132.333C49.6815 132.244 49.6953 132.148 49.6724 132.044C49.6388 131.944 49.5774 131.868 49.4884 131.818L48.3478 131.172L49.0284 129.969L50.4156 130.755ZM50.5135 136.145L49.8329 137.348L46.0619 135.211L46.7424 134.009L50.5135 136.145Z"
							fill="white" />
						<path
							d="M44.9722 127.184C45.473 127.553 45.8406 127.99 46.075 128.495C46.3093 129 46.4077 129.517 46.3699 130.047C46.3275 130.583 46.1383 131.079 45.8023 131.535C45.4664 131.992 45.0513 132.317 44.5571 132.51C44.0583 132.71 43.533 132.773 42.9813 132.699C42.4297 132.625 41.9034 132.404 41.4026 132.035L40.7941 131.587L41.613 130.474L42.2215 130.922C42.4878 131.118 42.7612 131.232 43.0417 131.262C43.3158 131.288 43.5814 131.239 43.8385 131.116C44.0846 130.994 44.2986 130.809 44.4806 130.562C44.6626 130.315 44.7775 130.052 44.8254 129.774C44.8623 129.498 44.8276 129.233 44.7214 128.979C44.6089 128.72 44.4195 128.493 44.1533 128.297L43.5447 127.848L44.3636 126.735L44.9722 127.184Z"
							fill="white" />
						<path
							d="M41.6975 124.669L35.7976 130.955L34.6184 129.848L36.6874 127.643C36.3637 127.62 36.0661 127.54 35.7945 127.404C35.523 127.267 35.2839 127.102 35.0773 126.908C34.6527 126.509 34.3862 126.091 34.2778 125.655C34.1637 125.212 34.1779 124.777 34.3204 124.35C34.4628 123.922 34.7038 123.527 35.0432 123.165L37.4113 120.642L38.5904 121.75L36.2224 124.273C36.0553 124.451 35.9475 124.652 35.8989 124.877C35.8449 125.107 35.852 125.335 35.9204 125.561C35.983 125.782 36.1033 125.976 36.2811 126.143C36.4533 126.305 36.6544 126.413 36.8844 126.467C37.1032 126.521 37.3259 126.52 37.5524 126.463C37.7678 126.406 37.9563 126.291 38.118 126.119L40.5184 123.561L41.6975 124.669Z"
							fill="white" />
						<path
							d="M30.8617 112.066C31.0595 112.369 31.1687 112.688 31.1894 113.023C31.1991 113.355 31.0889 113.676 30.8588 113.986L26.0457 120.075L25.0201 118.502L29.5077 113.189C29.5452 113.146 29.5653 113.105 29.5679 113.066C29.5661 113.02 29.5524 112.977 29.5266 112.937C29.5008 112.898 29.4694 112.871 29.4324 112.858C29.3911 112.838 29.3431 112.836 29.2884 112.853L22.5819 114.763L21.6014 113.259L29.0944 111.301C29.4598 111.213 29.798 111.242 30.1087 111.387C30.4129 111.536 30.6639 111.763 30.8617 112.066Z"
							fill="white" />
						<path
							d="M27.5466 106.671L22.1467 109.339L21.4254 107.877L26.8254 105.209L27.5466 106.671ZM21.1402 108.927C21.2621 109.174 21.2802 109.433 21.1943 109.704C21.0979 109.971 20.9262 110.166 20.6791 110.288C20.4321 110.41 20.1767 110.426 19.9132 110.337C19.639 110.244 19.441 110.074 19.319 109.827C19.1971 109.58 19.1843 109.323 19.2807 109.055C19.3666 108.785 19.5331 108.588 19.7801 108.466C20.0272 108.344 20.2878 108.33 20.5619 108.423C20.8255 108.512 21.0182 108.68 21.1402 108.927Z"
							fill="white" />
						<path
							d="M24.6875 99.7012C24.8551 100.176 24.9315 100.629 24.9166 101.061C24.8916 101.487 24.7864 101.875 24.6007 102.224C24.4077 102.576 24.1491 102.885 23.825 103.149C23.4936 103.417 23.1051 103.629 22.6597 103.786C22.0955 103.986 21.5625 104.049 21.0607 103.975C20.549 103.897 20.0985 103.697 19.7095 103.375C19.3178 103.046 19.0251 102.607 18.8313 102.057C18.7475 101.82 18.701 101.581 18.6919 101.342C18.6801 101.096 18.7059 100.862 18.7692 100.639C18.8326 100.416 18.93 100.219 19.0615 100.047L19.0575 100.036L15.9061 101.149L15.3678 99.6231L20.546 97.7945C21.1697 97.5743 21.7585 97.5041 22.3127 97.584C22.8594 97.6665 23.3375 97.8859 23.7471 98.2422C24.1567 98.5986 24.4701 99.0849 24.6875 99.7012ZM23.3846 100.161C23.2772 99.8568 23.1113 99.6232 22.8869 99.4603C22.6624 99.2974 22.4044 99.2048 22.1127 99.1826C21.8184 99.1529 21.5153 99.1932 21.2035 99.3033C20.8917 99.4134 20.6305 99.5724 20.42 99.7803C20.2069 99.9808 20.0641 100.215 19.9915 100.483C19.919 100.75 19.9364 101.037 20.0438 101.341C20.1486 101.638 20.3145 101.872 20.5416 102.042C20.766 102.205 21.0254 102.301 21.3197 102.331C21.6114 102.353 21.9131 102.309 22.2249 102.199C22.5368 102.089 22.7992 101.934 23.0123 101.733C23.2229 101.525 23.3644 101.287 23.4369 101.02C23.5068 100.744 23.4894 100.458 23.3846 100.161Z"
							fill="white" />
						<path
							d="M22.4613 92.4873C22.6106 93.1558 22.6143 93.7681 22.4723 94.3243C22.321 94.8745 22.0534 95.3377 21.6695 95.714C21.284 96.0826 20.8146 96.3287 20.2614 96.4525C19.639 96.5916 19.069 96.586 18.5514 96.4355C18.0337 96.2851 17.5992 96.0192 17.2478 95.6379C16.8964 95.2567 16.6589 94.7894 16.5353 94.2362C16.3877 93.5754 16.4066 93.0104 16.5923 92.5413C16.7762 92.0645 17.081 91.6777 17.5068 91.3808C17.9249 91.0856 18.4182 90.8744 18.9868 90.7472C19.0636 90.73 19.1567 90.7133 19.266 90.6969C19.3676 90.6822 19.447 90.6766 19.5042 90.6799L20.3925 94.6563C20.617 94.5415 20.7936 94.3931 20.9223 94.2111C21.0493 94.0213 21.1302 93.8055 21.165 93.5638C21.1903 93.3161 21.1712 93.0501 21.1077 92.7658L20.7421 91.1292L22.0905 90.8276L22.4613 92.4873ZM19.3348 94.9049L18.7863 92.45C18.6438 92.498 18.5153 92.5549 18.401 92.6209C18.279 92.6885 18.1757 92.7681 18.0913 92.8595C18.0068 92.951 17.9404 93.0506 17.8918 93.1583C17.8433 93.266 17.8135 93.3856 17.8026 93.5171C17.7916 93.6486 17.8024 93.7874 17.835 93.9334C17.878 94.1255 17.9512 94.2906 18.0546 94.4288C18.1564 94.5594 18.2761 94.6617 18.4136 94.7358C18.5512 94.8099 18.6999 94.8614 18.8596 94.8902C19.0176 94.9114 19.176 94.9163 19.3348 94.9049Z"
							fill="white" />
						<path
							d="M21.5204 85.6829C21.5828 86.3017 21.5014 86.8678 21.2762 87.3812C21.0431 87.8953 20.7058 88.3171 20.2642 88.6465C19.8148 88.9768 19.2964 89.1715 18.7089 89.2308C18.1214 89.2901 17.5784 89.2025 17.0799 88.9679C16.5737 88.7341 16.159 88.3882 15.8358 87.9302C15.5049 87.473 15.3082 86.935 15.2458 86.3161C15.1834 85.6973 15.2687 85.1308 15.5018 84.6166C15.727 84.1033 16.0643 83.6815 16.5137 83.3513C16.9553 83.0218 17.4698 82.8274 18.0573 82.7681C18.6448 82.7089 19.1917 82.7961 19.698 83.0299C20.1964 83.2645 20.6111 83.6103 20.9421 84.0676C21.2652 84.5256 21.458 85.064 21.5204 85.6829ZM20.1456 85.8216C20.1125 85.4926 20.0057 85.2185 19.8253 84.9993C19.6442 84.7723 19.4141 84.6095 19.1351 84.5111C18.8554 84.4048 18.551 84.3682 18.222 84.4014C17.893 84.4346 17.602 84.5313 17.3491 84.6913C17.0954 84.8435 16.9025 85.049 16.7703 85.3076C16.6373 85.5584 16.5874 85.8484 16.6206 86.1774C16.6537 86.5064 16.7609 86.7844 16.942 87.0114C17.1224 87.2306 17.3525 87.3934 17.6322 87.4996C17.9112 87.5981 18.2152 87.6307 18.5442 87.5975C18.8732 87.5643 19.1646 87.4716 19.4183 87.3194C19.6712 87.1593 19.8641 86.9539 19.9971 86.7031C20.1293 86.4444 20.1788 86.1506 20.1456 85.8216Z"
							fill="white" />
						<path
							d="M22.6714 71.8494C22.509 72.4661 22.24 72.9774 21.8645 73.3832C21.4813 73.787 21.0177 74.0638 20.4735 74.2135C19.9237 74.3535 19.3214 74.3372 18.6667 74.1646L13.7105 72.8582L14.1405 71.225L19.1995 72.5586C19.4964 72.6369 19.7865 72.6482 20.0698 72.5926C20.3455 72.535 20.5896 72.4121 20.802 72.2238C21.0068 72.0335 21.1503 71.7823 21.2325 71.4701C21.3147 71.158 21.3135 70.8686 21.229 70.6021C21.1369 70.3335 20.9851 70.1062 20.7735 69.9202C20.5544 69.7321 20.2963 69.599 19.9994 69.5207L14.9405 68.1871L15.3705 66.554L20.4295 67.8876C20.7264 67.9658 21.0165 67.9772 21.2998 67.9216C21.5755 67.864 21.8196 67.7411 22.032 67.5528C22.2368 67.3625 22.3803 67.1113 22.4625 66.7991C22.5447 66.487 22.5435 66.1976 22.459 65.9311C22.3669 65.6625 22.2151 65.4352 22.0035 65.2492C21.7844 65.0611 21.5263 64.928 21.2294 64.8497L16.1704 63.5161L16.6005 61.883L21.5567 63.1895C22.2114 63.3621 22.7425 63.6486 23.15 64.0492C23.5518 64.4401 23.82 64.9057 23.9545 65.4459C24.0815 65.9842 24.0637 66.5617 23.9013 67.1784C23.8171 67.4982 23.6951 67.7917 23.5351 68.0589C23.3828 68.3282 23.1957 68.5598 22.9736 68.7536C22.7516 68.9475 22.5051 69.1105 22.2342 69.2427C22.4069 69.4836 22.5411 69.747 22.6368 70.0328C22.7269 70.3089 22.7758 70.6027 22.7833 70.9141C22.7929 71.2179 22.7556 71.5297 22.6714 71.8494Z"
							fill="white" />
						<path
							d="M25.1739 58.6805C24.9711 59.193 24.6627 59.5873 24.2485 59.8636C23.8344 60.1399 23.3657 60.2972 22.8425 60.3356C22.3149 60.3637 21.7839 60.2719 21.2495 60.0602C20.7005 59.8427 20.2491 59.5284 19.8953 59.1173C19.5444 58.6988 19.3292 58.2155 19.2498 57.6675C19.163 57.1165 19.2427 56.5299 19.4889 55.9076C19.7381 55.278 20.0799 54.7994 20.5143 54.4719C20.9487 54.1444 21.4341 53.9555 21.9704 53.9055C22.5067 53.8554 23.0457 53.9377 23.5874 54.1522L26.3762 55.257L25.7809 56.7615L24.8476 56.3918L24.8389 56.4137C24.9931 56.6018 25.1174 56.812 25.2118 57.0441C25.3091 57.269 25.359 57.5174 25.3615 57.7894C25.3639 58.0613 25.3014 58.3584 25.1739 58.6805ZM24.0588 57.7433C24.1747 57.4505 24.2014 57.1689 24.139 56.8986C24.0766 56.6283 23.9427 56.389 23.7373 56.1806C23.5275 55.9619 23.2688 55.7917 22.9614 55.67C22.654 55.5482 22.3563 55.498 22.0684 55.5194C21.7761 55.5307 21.5147 55.6134 21.2843 55.7677C21.0539 55.9221 20.8807 56.1456 20.7649 56.4385C20.6461 56.7386 20.6164 57.0275 20.6759 57.3051C20.7383 57.5754 20.8708 57.8184 21.0733 58.0342C21.2714 58.2397 21.5242 58.4033 21.8316 58.5251C22.139 58.6469 22.4426 58.7036 22.7422 58.6953C23.0374 58.6767 23.3002 58.5903 23.5307 58.436C23.764 58.2744 23.94 58.0435 24.0588 57.7433Z"
							fill="white" />
						<path
							d="M28.4461 51.3412C28.1912 51.812 27.8557 52.1093 27.4396 52.233C27.0272 52.3498 26.5891 52.2826 26.1253 52.0313L21.0063 49.2573L21.7765 47.8345L26.854 50.5859C26.944 50.6346 27.0404 50.6466 27.1434 50.6218C27.2432 50.5863 27.3174 50.5236 27.3661 50.4336L27.9902 49.2808L29.205 49.9391L28.4461 51.3412ZM23.0611 51.5394L21.8463 50.8811L23.9095 47.0695L25.1244 47.7278L23.0611 51.5394Z"
							fill="white" />
						<path
							d="M31.9133 45.8309C31.5542 46.3388 31.1244 46.7146 30.6241 46.9585C30.1238 47.2024 29.6087 47.3104 29.0787 47.2826C28.5424 47.2501 28.0429 47.0702 27.5802 46.7426C27.1175 46.4151 26.7848 46.006 26.5822 45.5153C26.3731 45.02 26.3003 44.4958 26.3636 43.9425C26.427 43.3893 26.6382 42.8588 26.9973 42.3509L27.4337 41.7338L28.5615 42.5322L28.1251 43.1493C27.9342 43.4193 27.8261 43.6949 27.8008 43.976C27.7801 44.2507 27.834 44.5155 27.9623 44.7704C28.0888 45.0143 28.2773 45.2249 28.528 45.4023C28.7786 45.5797 29.0431 45.6898 29.3214 45.7325C29.5979 45.7642 29.8622 45.7246 30.1142 45.6137C30.3708 45.4963 30.5946 45.3026 30.7855 45.0326L31.2219 44.4154L32.3497 45.2138L31.9133 45.8309Z"
							fill="white" />
						<path
							d="M34.3639 42.5038L27.9707 36.7199L29.0555 35.5195L31.2975 37.5478C31.3146 37.2236 31.3887 36.9243 31.5198 36.6501C31.6509 36.3759 31.8115 36.1336 32.0015 35.9233C32.3922 35.4911 32.8047 35.2166 33.2391 35.1C33.6787 34.9775 34.1137 34.9835 34.544 35.118C34.9743 35.2524 35.3734 35.4861 35.7412 35.8188L38.3072 38.1403L37.2224 39.3407L34.6564 37.0192C34.4754 36.8555 34.2723 36.7514 34.0472 36.707C33.8162 36.6572 33.5883 36.6687 33.3634 36.7414C33.1439 36.8082 32.9523 36.9321 32.7886 37.1132C32.6303 37.2884 32.5262 37.4916 32.4766 37.7227C32.4263 37.9427 32.432 38.1654 32.4935 38.3909C32.5544 38.6053 32.6725 38.7918 32.8476 38.9502L35.4487 41.3034L34.3639 42.5038Z"
							fill="white" />
						<path
							d="M46.749 31.4197C46.4495 31.6233 46.1329 31.7386 45.7991 31.7657C45.4674 31.7818 45.1444 31.6776 44.8303 31.4533L38.6551 26.7549L40.2079 25.699L45.6009 30.0867C45.6449 30.1234 45.6866 30.1427 45.7259 30.1445C45.7717 30.1419 45.8141 30.1274 45.8532 30.1008C45.8923 30.0742 45.9182 30.0423 45.931 30.0051C45.9502 29.9634 45.9509 29.9153 45.933 29.8609L43.8995 23.1889L45.3839 22.1795L47.48 29.6373C47.5749 30.0012 47.5528 30.34 47.4136 30.6536C47.2701 30.9606 47.0485 31.216 46.749 31.4197Z"
							fill="white" />
						<path
							d="M52.0809 28.0051L49.314 22.6552L50.7613 21.9059L53.5281 27.2558L52.0809 28.0051ZM49.7067 21.6407C49.462 21.7674 49.2035 21.7904 48.9313 21.7096C48.6625 21.6183 48.4648 21.4503 48.3382 21.2055C48.2116 20.9607 48.1905 20.7057 48.2748 20.4404C48.3626 20.1644 48.5288 19.9631 48.7735 19.8364C49.0182 19.7097 49.275 19.692 49.5438 19.7833C49.816 19.8641 50.0154 20.0268 50.142 20.2716C50.2686 20.5163 50.288 20.7767 50.2003 21.0526C50.1159 21.318 49.9514 21.514 49.7067 21.6407Z"
							fill="white" />
						<path
							d="M58.9916 25.0094C58.5197 25.1861 58.0681 25.2712 57.6369 25.2645C57.2103 25.2477 56.8207 25.1498 56.4679 24.9708C56.1124 24.7845 55.7993 24.5318 55.5287 24.2128C55.2553 23.8864 55.0358 23.502 54.8703 23.0596C54.6606 22.4991 54.5878 21.9673 54.6518 21.4642C54.7203 20.9509 54.9119 20.4966 55.2264 20.1014C55.5482 19.7034 55.982 19.4023 56.5276 19.198C56.7635 19.1096 57.0008 19.0586 57.2395 19.0449C57.4855 19.0284 57.7204 19.0497 57.9443 19.1088C58.1681 19.1679 58.3671 19.2615 58.5411 19.3897L58.5522 19.3856L57.3812 16.2552L58.8964 15.6878L60.8205 20.8313C61.0522 21.4508 61.1333 22.0383 61.0638 22.594C60.9915 23.1423 60.781 23.6247 60.4324 24.0411C60.0838 24.4575 59.6035 24.7802 58.9916 25.0094ZM58.5074 23.7152C58.8097 23.602 59.0402 23.4317 59.1989 23.2041C59.3575 22.9765 59.4452 22.7167 59.4621 22.4246C59.4862 22.1297 59.4404 21.8273 59.3245 21.5176C59.2087 21.2079 59.0449 20.9498 58.8331 20.7432C58.6287 20.5339 58.392 20.3956 58.123 20.3282C57.854 20.2608 57.5684 20.2837 57.2661 20.3969C56.9712 20.5073 56.7407 20.6777 56.5747 20.908C56.416 21.1356 56.3246 21.3968 56.3004 21.6917C56.2836 21.9838 56.3331 22.2848 56.449 22.5945C56.5648 22.9042 56.725 23.1637 56.9294 23.373C57.1411 23.5796 57.3815 23.7165 57.6505 23.7839C57.9269 23.8486 58.2125 23.8257 58.5074 23.7152Z"
							fill="white" />
						<path
							d="M66.158 22.6455C65.4925 22.8075 64.8804 22.8229 64.3217 22.6915C63.7689 22.5507 63.3008 22.2919 62.9175 21.9153C62.5418 21.5368 62.287 21.0721 62.153 20.5213C62.0022 19.9017 61.9973 19.3316 62.138 18.8111C62.2788 18.2906 62.5365 17.851 62.9111 17.4924C63.2858 17.1337 63.7484 16.8873 64.2992 16.7532C64.9571 16.593 65.5222 16.6012 65.9947 16.7779C66.4747 16.9527 66.8672 17.2501 67.1719 17.6702C67.4748 18.0826 67.6951 18.5719 67.8328 19.138C67.8515 19.2145 67.87 19.3072 67.8884 19.4162C67.9049 19.5175 67.912 19.5968 67.9098 19.6541L63.9511 20.6182C64.07 20.8405 64.2216 21.0142 64.406 21.1395C64.5981 21.2629 64.8153 21.3396 65.0576 21.3698C65.3057 21.3904 65.5713 21.3662 65.8543 21.2973L67.4837 20.9004L67.8103 22.243L66.158 22.6455ZM63.6828 19.5653L66.1268 18.97C66.0762 18.8284 66.0168 18.7011 65.9488 18.588C65.8789 18.4672 65.7975 18.3655 65.7044 18.2828C65.6114 18.2002 65.5106 18.1356 65.4021 18.0891C65.2935 18.0426 65.1734 18.0151 65.0417 18.0067C64.91 17.9982 64.7715 18.0117 64.6261 18.0471C64.4349 18.0937 64.2711 18.17 64.1349 18.2761C64.0063 18.3804 63.9062 18.502 63.8347 18.641C63.7632 18.7799 63.7145 18.9296 63.6887 19.0898C63.6705 19.2482 63.6685 19.4067 63.6828 19.5653Z"
							fill="white" />
						<path
							d="M72.9396 21.5759C72.322 21.65 71.7545 21.5793 71.237 21.3639C70.7186 21.1406 70.2906 20.8114 69.953 20.3761C69.6144 19.933 69.41 19.4184 69.3397 18.8321C69.2694 18.2458 69.3468 17.7012 69.572 17.1984C69.7963 16.6878 70.1343 16.2666 70.5862 15.9348C71.0371 15.5952 71.5714 15.3883 72.1889 15.3142C72.8065 15.2401 73.3745 15.3147 73.8929 15.5379C74.4103 15.7533 74.8383 16.0826 75.1769 16.5257C75.5146 16.9609 75.7185 17.4717 75.7888 18.058C75.8591 18.6443 75.7821 19.1928 75.5579 19.7034C75.3327 20.2062 74.9946 20.6274 74.5437 20.967C74.0918 21.2988 73.5571 21.5017 72.9396 21.5759ZM72.7751 20.2039C73.1034 20.1645 73.3755 20.0526 73.5912 19.8681C73.8148 19.6826 73.9732 19.4495 74.0664 19.1687C74.1675 18.887 74.1983 18.582 74.1589 18.2536C74.1196 17.9253 74.0175 17.6362 73.8528 17.3864C73.6958 17.1356 73.4868 16.9466 73.2258 16.8193C72.9725 16.6911 72.6817 16.6467 72.3534 16.6861C72.0251 16.7256 71.7491 16.838 71.5255 17.0234C71.3098 17.2079 71.1514 17.441 71.0503 17.7227C70.9571 18.0035 70.9302 18.3081 70.9696 18.6364C71.0089 18.9648 71.1071 19.2543 71.264 19.5051C71.4288 19.7549 71.6378 19.9439 71.891 20.0721C72.1521 20.1994 72.4468 20.2433 72.7751 20.2039Z"
							fill="white" />
						<path
							d="M91.0659 76.7767C94.062 78.3918 94.062 82.5727 91.0659 84.1878L72.9759 93.9396C70.064 95.5093 66.4856 93.4662 66.4856 90.234L66.4856 70.7305C66.4856 67.4983 70.064 65.4552 72.9759 67.0249L91.0659 76.7767Z"
							fill="white" />
					</g>
					<defs>
						<clipPath id="bgblur_0_2273_1734_clip_path" transform="translate(101.587 101.587)">
							<rect width="160" height="160" rx="80" />
						</clipPath>
						<linearGradient id="paint0_linear_2273_1734" x1="80" y1="0" x2="80" y2="160"
							gradientUnits="userSpaceOnUse">
							<stop stop-color="white" />
							<stop offset="0.295" stop-color="white" stop-opacity="0.2" />
							<stop offset="1" stop-color="white" />
						</linearGradient>
					</defs>
				</svg>
			</div>

		</div>



	</div>





	<div class="tabsSideHeaderPro">

		<div class="tabsSide">

			<?php if (!empty($product_pecifics)) { ?>

				<a href="#product_pecifics">مشخصات محصول</a>

			<?php } ?>

			<?php if (!empty($main_explaintion)) { ?>

				<a href="#main_explaintion">معرفی</a>

			<?php } ?>

			<?php if (!empty($how_to_use)) { ?>

				<a href="#how_to_use">مصرف دارو</a>

			<?php } ?>

			<?php if (!empty($source_drug)) { ?>

				<a href="#source_drug">منع مصرف</a>

			<?php } ?>

			<?php if (!empty($seciurity_points)) { ?>

				<a href="#seciurity_points">موارد احتیاط</a>

			<?php } ?>

			<?php if (!empty($fight_drug)) { ?>

				<a href="#fight_drug">تداخل دارویی</a>

			<?php } ?>

			<?php if (!empty($info_profession)) { ?>

				<a href="#info_profession">اطلاعات تخصصی</a>

			<?php } ?>


			<a href="">محصولات متشابه</a>


		</div>

		<?php if (empty($product_catalog)) { ?>

			<div class="catalugeSide">

				<a href="#" class="generalBtn">کاتالوگ محصولات</a>

			</div>

		<?php } ?>

	</div>




	<?php if (!empty($product_pecifics['0'])) { ?>

		<div class="productPecifics deActiveContentScroll" id="product_pecifics">
			<span>مشخصات محصول</span>
			<div class="infoProfessionItems">
				<?php foreach ($product_pecifics as $infop) { ?>

					<div>
						<span>
							<?php echo $infop['title']; ?>
						</span>
						<span>
							<?php echo $infop['explain']; ?>
						</span>
					</div>

				<?php } ?>
			</div>
		</div>

	<?php } ?>


	<?php if (!empty($main_explaintion)) { ?>

		<div class="entry-content mainExplaintion deActiveContentScroll" id="main_explaintion">
			<span>معرفی</span>
			<?php echo $main_explaintion; ?>
		</div>

	<?php } ?>


	<?php if (!empty($how_to_use)) { ?>

		<div class="entry-content howToUse deActiveContentScroll" id="how_to_use">
			<span>مصرف دارو</span>
			<?php echo $how_to_use; ?>
		</div>

	<?php } ?>


	<?php if (!empty($source_drug)) { ?>

		<div class="entry-content sourceDrug deActiveContentScroll" id="source_drug">
			<span>منع مصرف</span>
			<?php echo $source_drug; ?>
		</div>

	<?php } ?>


	<?php if (!empty($seciurity_points)) { ?>

		<div class="entry-content seciurityPoints deActiveContentScroll" id="seciurity_points">
			<span>موارد احتیاط</span>
			<?php echo $seciurity_points; ?>
		</div>

	<?php } ?>


	<?php if (!empty($fight_drug)) { ?>

		<div class="entry-content fightDrug deActiveContentScroll" id="fight_drug">
			<span>تداخل دارویی</span>
			<?php echo $fight_drug; ?>
		</div>

	<?php } ?>


	<?php if (!empty($info_profession)) { ?>

		<div class="entry-content infoProfession deActiveContentScroll" id="info_profession">
			<span>اطلاعات تخصصی</span>
			<?php echo $info_profession; ?>
		</div>

	<?php } ?>



</article>