<?php



if (!function_exists('payamava_list_product')) {
	function payamava_list_product($query = 'recent_project', $count = 6, $ids = null, $cat = null)
	{

		$args_project = [
			'post_type' => 'product',
			'posts_per_page' => $count,
			'orderby' => 'date',
			'order' => 'DESC',
			'post_status' => 'publish',
		];

		if ($query == 'custom_project' && $ids) {

			$args_project['post__in'] = $ids;
			$args_project['orderby'] = 'post__in';
		}

		if ($query == 'cat_project' && $cat) {
			$args_project['tax_query'] = [
				[
					'taxonomy' => 'product_cat',
					'field' => 'term_id',
					'terms' => $cat,
				],
			];
		}

		if ($query == 'var_project' && $cat) {
			$args_project['tax_query'] = [
				[
					'taxonomy' => 'product_fea',
					'field' => 'term_id',
					'terms' => $cat,
				],
			];
		}


		$project = new WP_Query($args_project);

		$html = '';

		if ($project->have_posts()) {

			ob_start();
			
			while ($project->have_posts()) {

				$project->the_post();

				echo '<div class="swiper-slide">';

				get_template_part('template-parts/cards/content', 'product');

				echo '</div>';

			}

			$html = ob_get_clean();

			wp_reset_postdata();

		}

		return $html;
	}
}








?>