<?php
/**
 * razan-payamava functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package razan-payamava
 */

if (!defined('_S_VERSION')) {
	// Replace the version number of the theme on each release.
	define('_S_VERSION', '1.0.0');
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function razan_payamava_setup()
{
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on razan-payamava, use a find and replace
	 * to change 'razan-payamava' to the name of your theme in all the template files.
	 */
	load_theme_textdomain('razan-payamava', get_template_directory() . '/languages');

	// Add default posts and comments RSS feed links to head.
	add_theme_support('automatic-feed-links');

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support('title-tag');

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support('post-thumbnails');

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__('Primary', 'razan-payamava'),
			'menu-2' => esc_html__('Secondary', 'razan-payamava'),
			'menu-3' => esc_html__('Mobile', 'razan-payamava'),
		)
	);

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'razan_payamava_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support('customize-selective-refresh-widgets');

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height' => 250,
			'width' => 250,
			'flex-width' => true,
			'flex-height' => true,
		)
	);
}
add_action('after_setup_theme', 'razan_payamava_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function razan_payamava_content_width()
{
	$GLOBALS['content_width'] = apply_filters('razan_payamava_content_width', 640);
}
add_action('after_setup_theme', 'razan_payamava_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function razan_payamava_widgets_init()
{
	register_sidebar(
		array(
			'name' => esc_html__('Sidebar', 'razan-payamava'),
			'id' => 'sidebar-1',
			'description' => esc_html__('Add widgets here.', 'razan-payamava'),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget' => '</section>',
			'before_title' => '<h2 class="widget-title">',
			'after_title' => '</h2>',
		)
	);
}
add_action('widgets_init', 'razan_payamava_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function razan_payamava_scripts()
{
	wp_enqueue_style('razan-payamava-style', get_stylesheet_uri(), array(), _S_VERSION);
	wp_style_add_data('razan-payamava-style', 'rtl', 'replace');


	wp_enqueue_script('jquery');


	// lightgallery
	wp_enqueue_script('lightgallery', get_template_directory_uri() . '/assets/lg/lightgallery.min.js', array(), '', true);
	wp_enqueue_script('lg-video', get_template_directory_uri() . '/assets/lg/lg-video.min.js', array(), _S_VERSION, true);
	wp_enqueue_script('lg-zoom', get_template_directory_uri() . '/assets/lg/lg-zoom.min.js', array(), _S_VERSION, true);
	wp_enqueue_script('lg-share', get_template_directory_uri() . '/assets/lg/lg-share.min.js', array(), _S_VERSION, true);
	wp_enqueue_script('lg-thumbnail', get_template_directory_uri() . '/assets/lg/lg-thumbnail.min.js', array(), _S_VERSION, true);
	wp_enqueue_style('lightgallery-bundle', get_template_directory_uri() . '/assets/lg/lightgallery-bundle.min.css');

	// Swiper
	wp_enqueue_style('swiper-styles', get_template_directory_uri() . '/assets/swiper/swiper-bundle.min.css', array(), _S_VERSION);
	wp_enqueue_script('swiper-scripts', get_template_directory_uri() . '/assets/swiper/swiper-bundle.min.js', array(), _S_VERSION, true);

	// Aos
	wp_enqueue_script('aos-script', get_template_directory_uri() . '/assets/aos/aos.js', array(), _S_VERSION, false);
	wp_enqueue_style('aos-style', get_template_directory_uri() . '/assets/aos/aos.css', array(), _S_VERSION);



	wp_enqueue_style('home-edit', get_template_directory_uri() . '/assets/css/home.css', array(), _S_VERSION);
	wp_enqueue_style('inner-edit', get_template_directory_uri() . '/assets/css/inner.css', array(), _S_VERSION);
	wp_enqueue_style('global-edit', get_template_directory_uri() . '/assets/css/global.css', array(), _S_VERSION);


	wp_enqueue_script('razan-payamava-swipers', get_template_directory_uri() . '/assets/js/swipers.js', array(), _S_VERSION, true);
	wp_enqueue_script('razan-payamava-header', get_template_directory_uri() . '/assets/js/header.js', array(), _S_VERSION, true);
	wp_enqueue_script('razan-payamava-basics', get_template_directory_uri() . '/assets/js/basics.js', array(), _S_VERSION, true);
	wp_enqueue_script('razan-payamava-global', get_template_directory_uri() . '/assets/js/global.js', array(), _S_VERSION, true);

	wp_enqueue_script('razan-payamava-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true);




	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'razan_payamava_scripts');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
	require get_template_directory() . '/inc/jetpack.php';
}



require_once get_template_directory() . '/inc/cutom/show-product-simple.php';

require_once get_template_directory() . '/inc/cutom/show-blog-simple.php';

require_once get_template_directory() . '/inc/cutom/pagination.php';

require_once get_template_directory() . '/inc/cutom/toc.php';

require_once get_template_directory() . '/inc/cutom/share-buttons.php';



function mytheme_custom_excerpt_length($length)
{
	return 20;
}
add_filter('excerpt_length', 'mytheme_custom_excerpt_length', 999);

function new_excerpt_more($more)
{
	return ' ... ';
}
add_filter('excerpt_more', 'new_excerpt_more');


