var $ = jQuery;

///////////// ّCOUNTER

function startCounters() {
  $(".counterItems .counterNum").each(function () {
    var $counter = $(this);
    var target = parseInt($counter.text());
    if (isNaN(target)) {
      return;
    }
    var current = 0;
    var increment;
    var intervalTime = 30;
    function calculateIncrementAndInterval(target, current) {
      var remaining = target - current;
      var increment, interval;
      if (remaining <= 10) {
        increment = Math.ceil(remaining / 1);
        interval = 120;
      } else if (remaining <= 50) {
        increment = Math.ceil(remaining / 3);
        interval = 90;
      } else if (remaining <= 300) {
        increment = Math.ceil(remaining / 13);
        interval = 60;
      } else if (remaining <= 700) {
        increment = Math.ceil(remaining / 34);
        interval = 40;
      } else {
        increment = Math.ceil(remaining / 76);
        interval = 20;
      }
      return { increment, interval };
    }
    function updateCounter() {
      var { increment, interval } = calculateIncrementAndInterval(
        target,
        current
      );
      current += increment;
      if (current >= target) {
        current = target;
        $counter.text(current);
        return; // Stop further updates
      }
      $counter.text(current);
      setTimeout(updateCounter, interval);
    }
    updateCounter();
  });
}
function isInViewport(element) {
  if ($(element).length === 0) {
    return false;
  }
  var elementTop = $(element).offset().top;
  var elementBottom = elementTop + $(element).outerHeight();
  var viewportTop = $(window).scrollTop();
  var viewportBottom = viewportTop + $(window).height();
  return elementBottom > viewportTop && elementTop < viewportBottom;
}
$(".counterItems").each(function () {
  let initialWidth = $(this).outerWidth(true);
  $(this).css({
    "min-width": initialWidth + 5 + "px",
  });
});
var counterStarted = false;
$(window).on("scroll", function () {
  if (!counterStarted && isInViewport($(".siteCounter"))) {
    counterStarted = true;
    startCounters();
  }
});
if (isInViewport($(".siteCounter"))) {
  counterStarted = true;
  startCounters();
}

/////////////  ABOUT US SECTION VIDEO

const video = document.getElementById("myVideoHome");
const playBtn = document.getElementById("playBtnHome");

if (video && playBtn) {
  playBtn.addEventListener("click", () => {
    video.play();
    video.setAttribute("controls", "controls");
    playBtn.classList.add("hidden");
  });

  video.addEventListener("pause", () => {
    video.removeAttribute("controls");
    playBtn.classList.remove("hidden");
  });

  video.addEventListener("ended", () => {
    video.removeAttribute("controls");
    playBtn.classList.remove("hidden");
  });
}

/////////////  ARCHIVE PRODUCT TABS

(function ($) {
  "use strict";

  $(document).ready(function () {
    function initTabs(tabContainerSelector) {
      var $tabContainer = $(tabContainerSelector);
      var $tabs = $tabContainer.find(".tab-item-product");
      var $contents = $tabContainer.next("main").find(".content-item-pruduct");

      $tabs.removeClass("active");
      $contents.removeClass("active").hide();
      $tabs.first().addClass("active");
      $contents.first().addClass("active").show();

      $tabs.on("click", function (e) {
        e.preventDefault();
        var $this = $(this);

        if ($this.hasClass("active")) return;

        var termId = $this.data("term-id");
        var $targetContent = $("#tab-product-" + termId);

        if ($targetContent.length === 0) return;

        $tabs.removeClass("active");
        $this.addClass("active");

        $contents.filter(".active").fadeOut(200, function () {
          $(this).removeClass("active");

          $targetContent.fadeIn(300).addClass("active");
        });
      });
    }

    $(".product-tabs-archive").each(function () {
      initTabs(this);
    });
  });
})(jQuery);

/////////////  ABOUT US TIMELINE

(function ($) {
  "use strict";

  $(document).ready(function () {
    function timeline(tabContainerSelector) {
      var $tabContainer = $(tabContainerSelector);
      var $tabs = $tabContainer.find(".goalsWishesBtnIN");
      var $contents = $tabContainer
        .next(".goalsWishesItems")
        .find(".goalsWishesInner");

      $tabs.removeClass("active");
      $contents.removeClass("active").hide();
      $tabs.first().addClass("active");
      $contents.first().addClass("active").show();

      $tabs.on("click", function (e) {
        e.preventDefault();
        var $this = $(this);

        if ($this.hasClass("active")) return;

        var termId = $this.data("term-id");
        var $targetContent = $("#" + termId);

        if ($targetContent.length === 0) return;

        $tabs.removeClass("active");
        $this.addClass("active");

        $contents.filter(".active").fadeOut(200, function () {
          $(this).removeClass("active");

          $targetContent.fadeIn(300).addClass("active");
        });
      });
    }

    $(".goalsWishesBtns").each(function () {
      timeline(this);
    });
  });
})(jQuery);

/////////////  ABOUT US GOALS

(function ($) {
  "use strict";

  $(document).ready(function () {
    const $tabs = $(".timelineSwiper .historyAboutBtnIN");
    const $contents = $(".historyAboutInner");

    // --- نمایش اولیه محتوا ---
    $contents.hide().removeClass("active");
    $contents.first().show().addClass("active");
    $tabs.removeClass("active");
    $tabs.first().addClass("active");

    // --- تابع فعال کردن محتوا ---
    function activateContent(index) {
      // توقف همه انیمیشن‌های قبلی، مخفی کردن همه، حذف کلاس active
      $contents.stop(true, true).hide().removeClass("active");
      $contents.eq(index).fadeIn(300).addClass("active");

      // تب مرتبط هم فعال شود
      $tabs.removeClass("active");
      $tabs.eq(index).addClass("active");
    }

    // --- کلیک روی تب ---
    $tabs.on("click", function (e) {
      e.preventDefault();
      const index = $(this).index();
      if (index === timelineSwiper.realIndex) return; // اگر روی همان تب کلیک شد کاری نکن
      timelineSwiper.slideToLoop(index); // حرکت Swiper به همان ایندکس
      activateContent(index);
    });

    // --- هماهنگی با Autoplay و Drag ---
    timelineSwiper.on("slideChange", function () {
      const index = timelineSwiper.realIndex;
      activateContent(index);
    });
  });
})(jQuery);

/////////////  PRODUCT PAGE ACTIONS

$(function () {
  var $sections = $(".deActiveContentScroll");
  var $tabs = $(".tabsSideHeaderPro .tabsSide a");

  function onScroll() {
    var scrollPos = $(window).scrollTop();
    var currentId = null;

    $sections.each(function () {
      var $sec = $(this);
      var top = $sec.offset().top;

      if (top <= scrollPos + 90) {
        currentId = $sec.attr("id");
      }
    });

    $tabs.removeClass("active");
    if (currentId) {
      $tabs.filter('[href="#' + currentId + '"]').addClass("active");
    }
  }

  $(window).on("scroll", onScroll);
  onScroll();
});

const videoSin = document.getElementById("myVideoHomeSin");
const playBtnSin = document.getElementById("playBtnHomeSin");
const videoSideTitleAn = document.getElementById("videoSideTitleAn");
const videoSide = document.getElementById("videoSide");

if (videoSin && playBtnSin) {
  playBtnSin.addEventListener("click", () => {
    videoSin.play();
    videoSin.setAttribute("controls", "controls");
    playBtnSin.classList.add("hidden");
    videoSideTitleAn.classList.add("active");
    videoSide.classList.add("active");
  });

  videoSin.addEventListener("pause", () => {
    videoSin.removeAttribute("controls");
    playBtnSin.classList.remove("hidden");
    videoSideTitleAn.classList.remove("active");
    videoSide.classList.remove("active");
  });

  videoSin.addEventListener("ended", () => {
    videoSin.removeAttribute("controls");
    playBtnSin.classList.remove("hidden");
    videoSideTitleAn.classList.remove("active");
    videoSide.classList.remove("active");
  });
}

/////////////  POST PAGE ACTIONS

$(".quikAccess.extra-quikAccess.extra-quikAccess-post .extra-tab-title").on(
  "click",
  function () {
    const $filterContent = $(this).siblings("ul");

    $filterContent.stop(true, true).slideToggle(200);
    $(this).toggleClass("active");
  }
);

$(".post-headings.extra-post-headings .extra-tab-title").on(
  "click",
  function () {
    const $filterContent = $(this).siblings("ul");

    $filterContent.stop(true, true).slideToggle(200);
    $(this).toggleClass("active");
  }
);
