<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package razan-payamava
 */


$image_logo_main = get_field('image_logo_main', 'options');
$icon_logo_main = get_field('icon_logo_main', 'options');
$call_number_header = get_field('call_number_header', 'options');


?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text"
			href="#primary"><?php esc_html_e('Skip to content', 'razan-payamava'); ?></a>

		<header id="masthead" class="site-header">

			<div class="upperHeaderParent">
				<div class="upperHeader mainView">

					<div class="searchSide" id="searchHeaderForm">

						<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path
								d="M4.5 10C4.5 6.96243 6.96243 4.5 10 4.5C13.0376 4.5 15.5 6.96243 15.5 10C15.5 13.0376 13.0376 15.5 10 15.5C6.96243 15.5 4.5 13.0376 4.5 10ZM10 3C6.13401 3 3 6.13401 3 10C3 13.866 6.13401 17 10 17C11.6628 17 13.1902 16.4202 14.3911 15.4518L19.7197 20.7803C20.0126 21.0732 20.4874 21.0732 20.7803 20.7803C21.0732 20.4874 21.0732 20.0126 20.7803 19.7197L15.4518 14.3911C16.4202 13.1902 17 11.6628 17 10C17 6.13401 13.866 3 10 3Z"
								fill="#68696E" />
						</svg>
						<input type="text" placeholder="دنبال چه چیزی میگردی؟" />

					</div>

					<div class="logoSide">

						<a href="<?php echo home_url(); ?>">

							<?php if (!empty($icon_logo_main)) { ?>

								<?php echo $icon_logo_main; ?>

							<?php } else { ?>

								<img src="<?php echo $image_logo_main; ?>" alt="">

							<?php } ?>

						</a>

					</div>

					<div class="catalogSide">
						<a href="#" class="generalBtn">کاتالوگ محصولات</a>
					</div>

				</div>
			</div>


			<div class="downerHeaderParent">
				<div class="downerHeader menuHeader mainView">

					<div class="rightSide">


						<div class="hambergerMenu" id="hambergerMenu">
							<svg width="24" height="24" viewBox="0 0 24 24" fill="none"
								xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M20.75 7C20.75 7.41421 20.4142 7.75 20 7.75L4 7.75C3.58579 7.75 3.25 7.41421 3.25 7C3.25 6.58579 3.58579 6.25 4 6.25L20 6.25C20.4142 6.25 20.75 6.58579 20.75 7Z"
									fill="white" />
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M20.75 12C20.75 12.4142 20.4142 12.75 20 12.75L4 12.75C3.58579 12.75 3.25 12.4142 3.25 12C3.25 11.5858 3.58579 11.25 4 11.25L20 11.25C20.4142 11.25 20.75 11.5858 20.75 12Z"
									fill="white" />
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M20.75 17C20.75 17.4142 20.4142 17.75 20 17.75L4 17.75C3.58579 17.75 3.25 17.4142 3.25 17C3.25 16.5858 3.58579 16.25 4 16.25L20 16.25C20.4142 16.25 20.75 16.5858 20.75 17Z"
									fill="white" />
							</svg>
						</div>

						<div class="resSearchIcon" id="resSearchIcon">
							<svg width="20" height="20" viewBox="0 0 20 20" fill="none"
								xmlns="http://www.w3.org/2000/svg">
								<path fill-rule="evenodd" clip-rule="evenodd"
									d="M9.16675 2.29166C5.36979 2.29166 2.29175 5.36971 2.29175 9.16666C2.29175 12.9636 5.36979 16.0417 9.16675 16.0417C12.9637 16.0417 16.0417 12.9636 16.0417 9.16666C16.0417 5.36971 12.9637 2.29166 9.16675 2.29166ZM1.04175 9.16666C1.04175 4.67935 4.67943 1.04166 9.16675 1.04166C13.6541 1.04166 17.2917 4.67935 17.2917 9.16666C17.2917 13.654 13.6541 17.2917 9.16675 17.2917C4.67943 17.2917 1.04175 13.654 1.04175 9.16666ZM16.7983 16.4593C16.6054 16.4446 16.4447 16.6053 16.4594 16.7982C16.4596 16.7993 16.4628 16.8207 16.4789 16.8811C16.4979 16.952 16.526 17.0462 16.5691 17.1898C16.6085 17.3214 16.6341 17.4067 16.6552 17.4701C16.6768 17.5349 16.6842 17.5473 16.681 17.5413C16.7689 17.7054 16.9788 17.7583 17.134 17.6556C17.1283 17.6594 17.1407 17.652 17.1905 17.6051C17.2391 17.5593 17.3021 17.4964 17.3993 17.3992C17.4965 17.302 17.5594 17.239 17.6052 17.1904C17.644 17.1491 17.6558 17.1335 17.6565 17.1326C17.7579 16.978 17.7053 16.7697 17.5427 16.6816C17.5417 16.6812 17.524 16.6731 17.4702 16.6551C17.4068 16.6341 17.3215 16.6084 17.1898 16.569C17.0463 16.526 16.9521 16.4978 16.8812 16.4789C16.8207 16.4627 16.7994 16.4595 16.7983 16.4593ZM15.2137 16.9028C15.1344 15.9389 15.939 15.1343 16.9028 15.2136C17.0695 15.2274 17.271 15.288 17.4886 15.3535C17.5085 15.3595 17.5285 15.3655 17.5486 15.3716C17.5668 15.377 17.5849 15.3824 17.6029 15.3878C17.8027 15.4474 17.9902 15.5033 18.1314 15.579C18.9447 16.0144 19.2072 17.0549 18.6979 17.8241C18.6094 17.9577 18.4709 18.0958 18.3233 18.2431C18.31 18.2563 18.2966 18.2697 18.2832 18.2831C18.2698 18.2965 18.2564 18.3099 18.2431 18.3232C18.0959 18.4708 17.9577 18.6093 17.8241 18.6978C17.055 19.2071 16.0145 18.9446 15.579 18.1314C15.5034 17.9901 15.4475 17.8027 15.3879 17.6028C15.3825 17.5848 15.3771 17.5667 15.3717 17.5486C15.3656 17.5284 15.3596 17.5084 15.3536 17.4885C15.2881 17.271 15.2274 17.0694 15.2137 16.9028Z"
									fill="white" />
							</svg>

						</div>


						<?php
						wp_nav_menu(
							array(
								'theme_location' => 'menu-1',
							)
						);
						?>
					</div>

					<div class="leftSide">
						<div class="secondaryMenu">
							<?php
							wp_nav_menu(
								array(
									'theme_location' => 'menu-2',
								)
							);
							?>
						</div>

						<?php if (!empty($call_number_header)) { ?>
							<a href="tel:<?php echo $call_number_header; ?>" class="numberBox">
								<span>
									<svg width="18" height="18" viewBox="0 0 18 18" fill="none"
										xmlns="http://www.w3.org/2000/svg">
										<path
											d="M12.7078 1.81352L11.8325 1.54969C10.8407 1.25072 9.7809 1.73389 9.35614 2.67876L8.67989 4.18305C8.31783 4.98843 8.50863 5.93493 9.15442 6.53714L10.2751 7.58223C10.3079 7.61278 10.3286 7.65404 10.3336 7.69855C10.3669 7.99641 10.165 8.57646 9.69976 9.38221C9.36147 9.96814 9.05529 10.379 8.79467 10.6102C8.61309 10.7712 8.51314 10.806 8.47058 10.7933L6.96285 10.3324C6.11865 10.0743 5.2038 10.382 4.68726 11.0979L3.72671 12.4292C3.12213 13.2671 3.23085 14.423 3.98107 15.1335L4.64583 15.7631C5.36315 16.4424 6.38431 16.6955 7.33588 16.4299C9.40144 15.8534 11.2534 14.1103 12.9123 11.237C14.5735 8.35969 15.1564 5.88135 14.6191 3.80251C14.3732 2.85115 13.6486 2.0971 12.7078 1.81352ZM12.3831 2.89065C12.9476 3.0608 13.3824 3.51323 13.5299 4.08404C13.9819 5.83268 13.4652 8.02932 11.9381 10.6745C10.4129 13.3161 8.7712 14.8613 7.03343 15.3463C6.46249 15.5057 5.84979 15.3538 5.4194 14.9462L4.75464 14.3167C4.41363 13.9937 4.36421 13.4683 4.63902 13.0874L5.59957 11.7562C5.83436 11.4308 6.2502 11.2909 6.63393 11.4082L8.14543 11.8703C9.02272 12.1318 9.81897 11.4257 10.674 9.94471C11.2503 8.94665 11.5188 8.17514 11.4517 7.57368C11.4169 7.2621 11.2717 6.97328 11.0424 6.75946L9.92167 5.71437C9.62813 5.44064 9.5414 5.01041 9.70597 4.64433L10.3822 3.14004C10.5753 2.71055 11.057 2.49093 11.5079 2.62683L12.3831 2.89065Z"
											fill="#D3AC69" />
									</svg>
								</span>
								<span>
									<?php echo $call_number_header; ?>
								</span>
							</a>
						<?php } ?>
						<?php if (!empty($call_number_header)) { ?>
							<a href="tel:<?php echo $call_number_header; ?>" class="mobileEmergencyCall">
								<svg width="20" height="20" viewBox="0 0 20 20" fill="none"
									xmlns="http://www.w3.org/2000/svg">
									<path
										d="M14.1196 2.01502L13.1471 1.72188C12.045 1.38968 10.8675 1.92655 10.3956 2.9764L9.64418 4.64784C9.2419 5.5427 9.4539 6.59437 10.1714 7.26349L11.4167 8.4247C11.4531 8.45864 11.4761 8.50449 11.4817 8.55395C11.5186 8.8849 11.2943 9.5294 10.7774 10.4247C10.4015 11.0757 10.0613 11.5323 9.77172 11.7891C9.56997 11.968 9.4589 12.0067 9.41162 11.9926L7.73636 11.4804C6.79837 11.1936 5.78186 11.5356 5.20794 12.331L4.14066 13.8102C3.4689 14.7412 3.5897 16.0256 4.42327 16.815L5.1619 17.5145C5.95893 18.2693 7.09354 18.5506 8.15085 18.2555C10.4459 17.6149 12.5037 15.6781 14.3469 12.4855C16.1927 9.28854 16.8404 6.53484 16.2433 4.22501C15.9701 3.16794 15.165 2.33012 14.1196 2.01502ZM13.7589 3.21183C14.3861 3.40089 14.8691 3.90358 15.0331 4.53783C15.5353 6.48076 14.9612 8.92147 13.2644 11.8605C11.5698 14.7957 9.74564 16.5126 7.81479 17.0515C7.18041 17.2286 6.49964 17.0598 6.02142 16.6069L5.2828 15.9074C4.9039 15.5486 4.84899 14.9648 5.15433 14.5416L6.22161 13.0624C6.48249 12.7009 6.94453 12.5454 7.3709 12.6758L9.05035 13.1892C10.0251 13.4798 10.9098 12.6953 11.8599 11.0497C12.5002 9.94073 12.7986 9.08349 12.7239 8.4152C12.6853 8.069 12.524 7.74808 12.2692 7.51051L11.0239 6.3493C10.6978 6.04515 10.6014 5.56712 10.7843 5.16036L11.5357 3.48893C11.7502 3.01172 12.2854 2.7677 12.7864 2.91869L13.7589 3.21183Z"
										fill="white" />
								</svg>
							</a>
						<?php } ?>
						<a href="#" class="langBox">
							<svg width="19" height="10" viewBox="0 0 19 10" fill="none"
								xmlns="http://www.w3.org/2000/svg">
								<path d="M7.35 8.274V9.8H0V0H7.154V1.526H1.82V4.074H6.552V5.572H1.82V8.274H7.35Z"
									fill="white" />
								<path
									d="M18.0869 0V9.8H16.5889L11.1849 3.164V9.8H9.37891V0H10.8769L16.2809 6.636V0H18.0869Z"
									fill="white" />
							</svg>

						</a>
					</div>

				</div>
			</div>



		</header><!-- #masthead -->







		<div class="backDropSubMeno" id="external-box"></div>




		<div class="menuMobilesection">
			<div class="upSidebarMenumobile">
				<a href="<?php echo site_url(); ?>">

				</a>
				<svg class="iconClose" width="24" height="24" viewBox="0 0 24 24" fill="none"
					xmlns="http://www.w3.org/2000/svg">
					<path d="M19 5 5 19m14 0L5 5" stroke="white" stroke-width="1" stroke-linecap="round"
						stroke-linejoin="round" />
				</svg>
			</div>
			<div class="downerNav">
				<nav id="site-navigation" class="main-navigation">
					<?php
					wp_nav_menu(
						array(
							'theme_location' => 'menu-3',
							'container_class' => 'menuSideBarMenumobile',
						)
					);
					?>
				</nav>
			</div>
		</div>




		<div class="backDropSearch" id="SearchsContainerBack"></div>





		<div class="SearchsContainer" id="SearchsContainer">

			<span class="closeSea mainView" id="closeSea">
				<svg width="34" height="34" viewBox="0 0 34 34" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd"
						d="M17.0007 33.6667C9.14391 33.6667 5.21554 33.6667 2.77476 31.2259C0.333984 28.7851 0.333984 24.8567 0.333984 17C0.333984 9.14325 0.333984 5.21488 2.77476 2.77411C5.21554 0.333328 9.14391 0.333328 17.0007 0.333328C24.8574 0.333328 28.7858 0.333328 31.2265 2.77411C33.6673 5.21488 33.6673 9.14325 33.6673 17C33.6673 24.8567 33.6673 28.7851 31.2265 31.2259C28.7858 33.6667 24.8574 33.6667 17.0007 33.6667ZM11.9501 11.9494C12.4382 11.4613 13.2297 11.4613 13.7178 11.9494L17.0006 15.2322L20.2834 11.9495C20.7716 11.4613 21.563 11.4613 22.0512 11.9495C22.5393 12.4376 22.5393 13.2291 22.0512 13.7172L18.7684 17L22.0511 20.2827C22.5393 20.7709 22.5393 21.5624 22.0511 22.0505C21.563 22.5387 20.7715 22.5387 20.2834 22.0505L17.0006 18.7678L13.7179 22.0505C13.2297 22.5387 12.4383 22.5387 11.9501 22.0505C11.4619 21.5624 11.4619 20.7709 11.9501 20.2828L15.2329 17L11.9501 13.7172C11.4619 13.2291 11.4619 12.4376 11.9501 11.9494Z"
						fill="white" />
				</svg>
			</span>
			<div class="search-input-div">
				<svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd"
						d="M20.79 22.9841C20.6858 21.7075 21.7424 20.6418 23.0079 20.7468C23.2273 20.7651 23.49 20.8449 23.7575 20.9262C23.7833 20.9341 23.8091 20.9419 23.835 20.9497C23.8583 20.9568 23.8816 20.9638 23.905 20.9708C24.1508 21.0447 24.3954 21.1182 24.5814 21.2187C25.6492 21.7954 25.9939 23.1736 25.3251 24.1923C25.2086 24.3698 25.0279 24.5515 24.8462 24.7342C24.829 24.7516 24.8117 24.7689 24.7945 24.7863C24.7773 24.8036 24.7601 24.821 24.7429 24.8384C24.5618 25.0217 24.3816 25.2039 24.2057 25.3215C23.1958 25.9961 21.8295 25.6484 21.2578 24.5712C21.1582 24.3836 21.0853 24.137 21.012 23.889C21.0051 23.8654 20.9981 23.8419 20.9911 23.8184C20.9834 23.7923 20.9756 23.7662 20.9678 23.7402C20.8872 23.4704 20.8081 23.2054 20.79 22.9841Z"
						fill="white" />
					<path
						d="M23.4831 13.0001C23.4831 18.8911 18.7487 23.6668 12.9085 23.6668C7.06836 23.6668 2.33398 18.8911 2.33398 13.0001C2.33398 7.109 7.06836 2.33334 12.9085 2.33334C18.7487 2.33334 23.4831 7.109 23.4831 13.0001Z"
						fill="white" />
				</svg>
				<input type="text" id="search-input" placeholder="جستجو..." />
			</div>


			<div class="searchResults">
				<div class="searchResultsChild">
					<div class="searchResultsHead">
						<span>پروژه‌ها</span>
						<a href="https://argopey.com/projects/">مشاهده همه<svg width="20" height="8" viewBox="0 0 20 8"
								fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M1 4L19 4L1 4Z" fill="#D3AC69" />
								<path d="M1 4L19 4" stroke="#D3AC69" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M4 1L1 4L4 7" fill="#D3AC69" />
								<path d="M4 1L1 4L4 7" stroke="#D3AC69" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
							</svg></a>
					</div>
					<div class="searchResultsBody" id="results-projects">

					</div>
				</div>
				<div class="searchResultsChild">
					<div class="searchResultsHead">
						<span>مقاله‌ها</span>
						<a href="https://argopey.com/%d8%a8%d9%84%d8%a7%da%af/">مشاهده همه<svg width="20" height="8"
								viewBox="0 0 20 8" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M1 4L19 4L1 4Z" fill="#D3AC69" />
								<path d="M1 4L19 4" stroke="#D3AC69" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
								<path d="M4 1L1 4L4 7" fill="#D3AC69" />
								<path d="M4 1L1 4L4 7" stroke="#D3AC69" stroke-width="1.5" stroke-linecap="round"
									stroke-linejoin="round" />
							</svg></a>
					</div>
					<div class="searchResultsBody" id="results-posts">

					</div>
				</div>
			</div>


		</div>