<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package razan-payamava
 */



$text_under_logo = get_field('text_under_logo', 'options');

$quik_access_sec = get_field('quik_access_sec', 'options');

$pure_links_sec = get_field('pure_links_sec', 'options');

$connect_path_sec = get_field('connect_path_sec', 'options');

$image_logo_main = get_field('image_logo_main', 'options');

$icon_logo_main = get_field('icon_logo_main', 'options');


$social_media_footer = get_field('social_media_footer', 'options');



?>

<footer id="colophon" class="site-footer">


	<div class="mainFooterBox mainView">


		<div class="footerItems footerItems1">

			<?php if (!empty($icon_logo_main)) { ?>

				<?php echo $icon_logo_main; ?>

			<?php } else { ?>

				<img src="<?php echo $image_logo_main; ?>" alt="">

			<?php } ?>

			<p><?php echo $text_under_logo; ?></p>

			<?php if ($social_media_footer['0']) { ?>
				<div class="footerSocialMedia">
					<?php foreach ($social_media_footer as $fede) { ?>
						<a href="<?php if ($fede['link']) {
							echo $fede['link'];
						} else {
							echo "#";
						} ?>" class="footerSocialMediaItem">
							<?php echo $fede['icon']; ?>
						</a>
					<?php } ?>
				</div>
			<?php } ?>

		</div>


		<?php if (!empty($connect_path_sec)) { ?>

			<div class="footerItems footerItems3">

				<div class="footerItemsTitle">
					<h4><?php echo $connect_path_sec['title']; ?></h4>
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M6 12H18" stroke="white" stroke-width="1.5" stroke-linecap="round"
							stroke-linejoin="round" />
						<path d="M12 18V6" stroke="white" stroke-width="1.5" stroke-linecap="round"
							stroke-linejoin="round" />
					</svg>
				</div>

				<ul>
					<?php if (!empty($connect_path_sec['numbers']['0'])) { ?>
						<li><svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path
									d="m7.9 13.859.352-.354zm-.456-.453-.353.355zm-2.417-.317.239.44zm-1.91 1.039.238.44zm-.539 3.255-.352.355zm1.42 1.412.353-.354zm1.326.67-.047.498zm9.86-4.238-.352-.355zm4.813-8.981.5.028zm-6.474 1.451-.353.355zm-.157-2.654-.4-.3zm1.26-1.684.401.3zm3.112-.284-.352.354zm1.57 1.56.353-.354zm-7.371 7.362-.353-.354zm-4.39 2.217-.456-.453.705-.71.456.454zm-2.281-.685-1.91 1.038-.478-.878 1.91-1.039zm-2.335 3.5 1.42 1.412-.705.709-1.42-1.412zm2.44 1.938c1.509.141 5.338.005 9.461-4.095l.705.71c-4.37 4.345-8.51 4.544-10.26 4.381zm9.461-4.095c3.916-3.894 4.583-7.19 4.666-8.655l.998.057c-.097 1.707-.865 5.237-4.959 9.307zm-1.375-6.535-.287-.285.705-.71.287.286zm-.492-3.593 1.261-1.685.801.6-1.261 1.684zm5.126-2.024 1.57 1.561-.705.71-1.57-1.562zM13.81 7.983a18 18 0 0 1 .355-.353l.002.002.004.005.034.037q.027.032.06.08c.044.065.094.153.136.266.087.23.137.544.075.945-.122.789-.675 1.885-2.186 3.387l-.705-.71c1.445-1.436 1.828-2.347 1.903-2.83.037-.236.002-.375-.023-.439a.3.3 0 0 0-.028-.058l.002.002.015.017.002.001v.001c.001 0 .002.001.354-.353m-1.52 4.369c-1.51 1.502-2.612 2.05-3.403 2.172a1.9 1.9 0 0 1-.946-.074 1.3 1.3 0 0 1-.347-.195l-.038-.033-.004-.005-.003-.003.351-.355c.353-.354.352-.355.352-.355l-.001-.001-.002-.002-.003-.003-.014-.013q-.006-.004-.001 0a.3.3 0 0 0 .06.028c.065.024.206.06.444.023.489-.075 1.406-.457 2.85-1.893zm1.938-9.293c.933-1.247 2.761-1.436 3.864-.339l-.705.71c-.646-.643-1.767-.562-2.359.229zm5.27 3.158c.026-.437-.177-.865-.541-1.227l.705-.709c.502.5.88 1.19.835 1.993zM4.352 18.441c.304.302.65.492 1.02.526l-.094.996c-.661-.062-1.212-.397-1.63-.813zM13.17 8.05c-.892-.886-.963-2.294-.204-3.307l.8.6c-.475.633-.412 1.48.109 1.999zm-9.815 6.516c-.954.519-1.129 1.76-.424 2.461l-.705.71c-1.213-1.207-.848-3.234.652-4.05zm3.736-.806c-.466-.463-1.205-.57-1.825-.232l-.478-.879c.991-.539 2.215-.387 3.008.402z"
									fill="#fff" />
							</svg>
							<?php foreach ($connect_path_sec['numbers'] as $num) { ?>

								<a href="tel:<?php if ($num['items']) {
									echo $num['items'];
								} else {
									echo "#";
								} ?>"><?php echo $num['items']; ?></a>

							<?php } ?>
						</li>
					<?php } ?>

					<?php if (!empty($connect_path_sec['emails']['0'])) { ?>
						<li><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path
									d="M2 12c0-3.771 0-5.657 1.172-6.828S6.229 4 10 4h4c3.771 0 5.657 0 6.828 1.172S22 8.229 22 12s0 5.657-1.172 6.828S17.771 20 14 20h-4c-3.771 0-5.657 0-6.828-1.172S2 15.771 2 12Z"
									stroke="#fff" />
								<path d="m6 8 2.159 1.8c1.837 1.53 2.755 2.295 3.841 2.295s2.005-.765 3.841-2.296L18 8"
									stroke="#fff" stroke-linecap="round" />
							</svg>
							<?php foreach ($connect_path_sec['emails'] as $mail) { ?>

								<a href="mailTo:<?php if ($mail['items']) {
									echo $mail['items'];
								} else {
									echo "#";
								} ?>"><?php echo $mail['items']; ?></a>

							<?php } ?>
						</li>
					<?php } ?>

					<?php if (!empty($connect_path_sec['address'])) { ?>

						<?php foreach ($connect_path_sec['address'] as $con_path) { ?>

							<li><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path
										d="M4 10.143C4 5.646 7.582 2 12 2s8 3.646 8 8.143c0 4.462-2.553 9.67-6.537 11.531a3.45 3.45 0 0 1-2.926 0C6.553 19.812 4 14.606 4 10.144Z"
										stroke="#fff" />
									<circle cx="12" cy="10" r="3" stroke="#fff" />
								</svg>
								<p><?php echo $con_path['addr']; ?></p>
							</li>

						<?php } ?>

					<?php } ?>
				</ul>

			</div>

		<?php } ?>


		<?php if (!empty($quik_access_sec['list_items']['0'])) { ?>

			<div class="footerItems footerItems2 footerItems21">

				<div class="footerItemsTitle">
					<h4><?php echo $quik_access_sec['title']; ?></h4>
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M6 12H18" stroke="white" stroke-width="1.5" stroke-linecap="round"
							stroke-linejoin="round" />
						<path d="M12 18V6" stroke="white" stroke-width="1.5" stroke-linecap="round"
							stroke-linejoin="round" />
					</svg>
				</div>

				<ul>
					<?php foreach ($quik_access_sec['list_items'] as $qas) { ?>

						<li><a href="<?php if ($qas['items']['url']) {
							echo $qas['items']['url'];
						} else {
							echo "#";
						} ?>"><?php echo $qas['items']['title']; ?></a>
						</li>

					<?php } ?>
				</ul>

			</div>

		<?php } ?>



		<?php if (!empty($pure_links_sec['list_items']['0'])) { ?>

			<div class="footerItems footerItems2 footerItems22">

				<div class="footerItemsTitle">
					<h4><?php echo $pure_links_sec['title']; ?></h4>
					<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M6 12H18" stroke="white" stroke-width="1.5" stroke-linecap="round"
							stroke-linejoin="round" />
						<path d="M12 18V6" stroke="white" stroke-width="1.5" stroke-linecap="round"
							stroke-linejoin="round" />
					</svg>
				</div>


				<ul>
					<?php foreach ($pure_links_sec['list_items'] as $pls) { ?>

						<li><a href="<?php if ($pls['items']['url']) {
							echo $pls['items']['url'];
						} else {
							echo "#";
						} ?>"><?php echo $pls['items']['title']; ?></a>
						</li>

					<?php } ?>
				</ul>



			</div>

		<?php } ?>



	</div>





</footer>



<div class="copyrightBack">
	<div class="copyright mainView">
		<p>تمامی حقوق مادی و معنوی این وبسایت متعلق به <span>رازان فارمد</span> می‌باشد.</p>
		<div class="payamAva">
			<?php include get_template_directory() . '/assets/img/payamAva.svg'; ?>
		</div>
	</div>
</div>





</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>