var $ = jQuery;

const mySwiperIntro = new Swiper(".mySwiperIntro", {
  direction: "horizontal",
  loop: true,

  navigation: {
    nextEl: ".swiper-button-next-mySwiperIntro",
    prevEl: ".swiper-button-prev-mySwiperIntro",
  },
  pagination: {
    el: ".swiper-pagination-mySwiperIntro",
    type: "custom",
    renderCustom: function (swiper, current, total) {
      const formatNumber = (num) => (num < 10 ? "0" + num : num);
      return `
      <span class="swiper-pagination-number-total">${formatNumber(total)}</span>
      <span class="swiper-pagination-separator">/</span>
      <span class="swiper-pagination-number-current">${formatNumber(
        current
      )}</span>
    `;
    },
  },

  slidesPerView: 1,
});

const productSwiper = new Swiper(".productSwiper", {
  direction: "horizontal",
  loop: true,
  slidesPerView: 1,

  navigation: {
    nextEl: ".swiper-button-next-productSwiper",
    prevEl: ".swiper-button-prev-productSwiper",
  },

  breakpoints: {
    450: {
      slidesPerView: 2,
      spaceBetween: 20,
    },
    990: {
      slidesPerView: 3,
      spaceBetween: 20,
    },
  },
});

const swiperHomeBlog = new Swiper(".swiperHomeBlog", {
  direction: "horizontal",
  loop: true,
  // autoplay: {
  //   delay: 3000,
  //   disableOnInteraction: false,
  // },
  slidesPerView: 1,
  spaceBetween: 20,

  navigation: {
    nextEl: ".swiper-button-next-swiperHomeBlog",
    prevEl: ".swiper-button-prev-swiperHomeBlog",
  },

  breakpoints: {
    600: {
      slidesPerView: 2,
    },
    800: {
      slidesPerView: 3,
    },
  },
});

const timelineSwiper = new Swiper(".timelineSwiper", {
  direction: "horizontal",
  slidesPerView: 3,
  spaceBetween: 10,
  centeredSlides: true,
  loop: true,
  autoplay: true,
  initialSlide: 2,

  breakpoints: {
    1000: {
      direction: "vertical",
      slidesPerView: 5,
    },
  },
});

const timelineSwiperImg = new Swiper(".timelineSwiperImg", {
  slidesPerView: 1,
  spaceBetween: 10,
  loop: true,
  initialSlide: 2,
  autoplay: true,
});

// Global LIGHT GALLERY

// Swiper For Img Gallery
const swGallery = new Swiper(".sw--gallery", {
  speed: 500,
  // centerInsufficientSlides: false,
  // freeMode: true,
  breakpointsBase: "container",
  grabCursor: true,
  rtl: true,
  // loop: true,
  ObjectwatchOverflow: true,
  pagination: {
    el: ".swiper-pagination.BuffCustom",
    type: "bullets",
    clickable: true,
  },

  breakpoints: {
    0: {
      slidesPerView: 1.4,
      spaceBetween: 20,
    },
    320: {
      slidesPerView: 2,
      spaceBetween: 10,
    },
    600: {
      slidesPerView: 3,
      spaceBetween: 5,
    },
    800: {
      slidesPerView: 4,
      spaceBetween: 15,
    },
    950: {
      slidesPerView: 6,
      spaceBetween: 18,
    },
    1200: {
      slidesPerView: 6,
      spaceBetween: 15,
    },
  },
});

// Config Gallery for post
let lgGallery = document.querySelectorAll(".page_lightgallery");
console.log(lgGallery);
if (lgGallery.length) {
  for (var i = 0; i < lgGallery.length; i++) {
    try {
      lightGallery(lgGallery[i], {
        thumbnail: true,
        speed: 500,
        plugins: [lgThumbnail, lgVideo, lgShare],
        selector: ".for-lightgallery",
        subHtmlSelectorRelative: true,
        mode: "lg-fade",
        fullScreen: true,
      });
    } catch (error) {
      console.log("no");
    }
  }
}
