<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package razan-payamava
 */

get_header();
?>

<?php
if (function_exists('rank_math_the_breadcrumbs')) { ?>
	<div class="responsiveBreadCramp mainView">
		<div class="rankMathBC">
			<?php
			rank_math_the_breadcrumbs();
			?>
		</div>
	</div>
<?php } ?>



<div class="titlePageCustome mainView">


	<div class="titlePageCustomeIMG">
		<img src="<?php echo get_template_directory_uri(); ?>/assets/img/bgglobal.webp" alt="">
	</div>


	<div class="rankMathBC">
		<?php
		if (function_exists('rank_math_the_breadcrumbs')) {
			rank_math_the_breadcrumbs();
		} ?>
	</div>

	<div class="mainHeaderContent">
		<span>PRODUCTS</span>
		<h1>محصولات</h1>
	</div>


</div>









<?php

$terms = get_terms([
	'taxonomy' => 'product_cat',
	'hide_empty' => true,
]);



if (!empty($terms) && !is_wp_error($terms)): ?>
	<div class="product-tabs-archive mainView">
		<?php foreach ($terms as $category):

			$term1 = get_term($category);
			$term1_link = get_term_link($term1);
			$acf_value = get_field('image_cat', 'term_' . $term1->term_id);

			?>

			<div class="productCategoryItems tab-item-product" data-term-id="<?php echo esc_attr($category->term_id); ?>">

				<div class="productCatImage">

					<?php echo $acf_value; ?>

				</div>

				<div class="productCatText">
					<h4>
						<?php echo esc_html($term1->name); ?>
					</h4>
					<span>
						<?php echo esc_html($term1->description); ?>
					</span>
				</div>

			</div>



		<?php endforeach; ?>
	</div>
<?php endif; ?>





<main id="primary" class="site-main mainView">



	<?php if (!empty($terms) && !is_wp_error($terms)): ?>


		<?php $i = 0; ?>

		<?php foreach ($terms as $term):

			$args = [
				'post_type' => 'product',
				'posts_per_page' => -1,
				'tax_query' => [
					[
						'taxonomy' => 'product_cat',
						'field' => 'id',
						'terms' => $term->term_id,
					],
				],
			];


			$query = new WP_Query($args);

			?>

			<?php if ($query->have_posts()): ?>

				<?php

				echo '<div class="archiveBlogParent content-item-pruduct ' . ($i === 0 ? 'active' : '') . '" id="tab-product-' . $term->term_id . '">';

				while ($query->have_posts()):

					$query->the_post();

					get_template_part('template-parts/cards/content', 'product');

				endwhile;

				echo '</div>';

			else:

				echo "<p class='nothingFoundPara'>" . esc_html__('هیچ محصولی یافت نشد.', 'textdomain') . "</p>";

			endif;
			?>

			<?php wp_reset_postdata(); ?>
			<?php $i++; ?>
		<?php endforeach; ?>

	<?php endif; ?>



</main>

<?php
get_footer();
